% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_cheem_lists.r
\name{cheem_ls}
\alias{cheem_ls}
\title{Preprocessing for use in shiny app}
\usage{
cheem_ls(
  x,
  y,
  class = NULL,
  model,
  attr_df,
  basis_type = c("pca", "olda"),
  layer_name = utils::tail(class(model), 1),
  verbose = getOption("verbose"),
  keep_model = FALSE
)
}
\arguments{
\item{x}{The explanatory variables of the model.}

\item{y}{The target variable of the model.}

\item{class}{The variable to group points by. Originally the \emph{predicted}
class.}

\item{model}{A non-linear model, originally a \code{randomForest::randomForest}
model fit, or a return from \code{default_rf()}.}

\item{attr_df}{A data frame of local explanation attributions,
such as a return from \code{attr_df_treeshap()}.}

\item{basis_type}{The type of basis used to approximate the data and
attribution space from. Expects "pca" or "olda" (requires \code{clas}).
Defaults to "pca".}

\item{layer_name}{Character layer name, typically the type of local
attribution used. Defaults to the last class of the model.}

\item{verbose}{Logical, if runtime should be printed. Defaults to TRUE.}

\item{keep_model}{Logical, whether or not the heavy model object should be
kept. Defaults to FALSE.}
}
\value{
A list of data.frames needed for the \code{shiny} application.
}
\description{
Performs the preprocessing steps needs to supply the plot functions
\code{global_view()} and \code{radial_cheem_tour()} used in the shiny app.
}
\examples{
library(cheem)
library(spinifex)

## Classification setup:
X    <- penguins_na.rm[, 1:4]
clas <- penguins_na.rm$species
Y    <- as.integer(clas)

## Model and treeSHAP explanation:
rf_fit  <- default_rf(X, Y)
shap_df <- attr_df_treeshap(rf_fit, X, noisy = FALSE)
this_ls <- cheem_ls(X, Y, class = clas,
                     model = rf_fit,
                     attr_df = shap_df)
global_view(this_ls) ## Preview spaces

## Save for used with shiny app (expects .rds):
if(FALSE){ ## Don't accidentally save.
  saveRDS(this_ls, "./my_cheem_ls.rds")
  run_app() ## Select the saved .rds file from the Data dropdown.
}



## Regression setup:
dat  <- amesHousing2018_NorthAmes
X    <- dat[, 1:9]
Y    <- dat$SalePrice
clas <- dat$SubclassMS

## Model and treeSHAP explanation:
rf_fit  <- default_rf(X, Y)
\donttest{
shap_df <- attr_df_treeshap(rf_fit, X, noisy = FALSE)
this_ls <- cheem_ls(X, Y, class = clas,
                     model = rf_fit,
                     attr_df = shap_df)
global_view(this_ls) ## Preview spaces
}

## Save for used with shiny app (expects .rds):
if(FALSE){ ## Don't accidentally save.
  saveRDS(this_ls, "./my_cheem_ls.rds")
  run_app() ## Select the saved .rds file from the Data dropdown.
}
}
\seealso{
\code{\link[=global_view]{global_view()}} \code{\link[=radial_cheem_tour]{radial_cheem_tour()}} \code{\link[=radial_cheem_tour]{radial_cheem_tour()}}

Other cheem preprocessing: 
\code{\link{attr_df_treeshap}()},
\code{\link{default_rf}()}
}
\concept{cheem preprocessing}
