% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_treeshap_minimal_port.r
\name{randomForest.unify}
\alias{randomForest.unify}
\title{Unify randomForest model}
\source{
\strong{treeshap}, \url{https://github.com/ModelOriented/treeshap}
}
\usage{
randomForest.unify(rf_model, data)
}
\arguments{
\item{rf_model}{An object of \code{randomForest} class. At the moment, models built on data with categorical features
are not supported - please encode them before training.}

\item{data}{Reference dataset. A \code{data.frame} or \code{matrix} with the same columns as in the training set of the model. Usually dataset used to train model.}
}
\value{
a unified model representation - a \code{\link{model_unified.object}} object
}
\description{
Convert your randomForest model into a standardized representation.
The returned representation is easy to be interpreted by the user and ready to be used as an argument in \code{treeshap()} function.
}
\examples{
library(cheem)

## Regression setup:
dat  <- amesHousing2018_NorthAmes
X    <- dat[, 1:9]
Y    <- dat$SalePrice
clas <- dat$SubclassMS

## Fit a model:
rf_model <- default_rf(X, Y)
unified_model <- randomForest.unify(rf_model, X)

## Calculate treeSHAP:
shaps <- treeshap(unified_model, X[1:2, ])
str(shaps)
}
\seealso{
\code{\link{unify_tree_model}}, a wrapper function unifying these models.
\code{\link{lightgbm.unify}} for \code{\link[lightgbm:lightgbm]{LightGBM models}}
\code{\link{gbm.unify}} for \code{\link[gbm:gbm]{GBM models}}
\code{\link{xgboost.unify}} for \code{\link[xgboost:xgboost]{XGBoost models}}
\code{\link{ranger.unify}} for \code{\link[ranger:ranger]{ranger models}}
}
\author{
Konrad Komisarczyk, Przemyslaw Biecek, et al.
}
