% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7_presaved_attribution.r
\docType{data}
\name{chocolates_svm_pred}
\alias{chocolates_svm_pred}
\alias{chocolates_svm_shap}
\title{Chocolate svm model predictions and shap values}
\format{
\code{chocolate_svm_pred} is a n=88 length vector of the prediction of an
svm model predicting the number of the factor level of the species of penguin.
\code{chocolate_svm_shap} is a (88 x 10) data frame of the DALEX SHAP attribution
of the svm model for each observation.

\strong{Replicating}

\if{html}{\out{<div class="sourceCode">}}\preformatted{library(cheem)
library(e1071)
library(DALEX)

## Classification setup
X    <- chocolates[, 5:14]
Y    <- chocolates$Type
clas <- chocolates$Type

## Model and predict
choc_svm_fit <- svm(
  formula = Y ~ ., data = data.frame(Y, X),
  type = 'C-classification', kernel = 'linear', probability = TRUE)
chocolates_svm_pred <- predict(choc_svm_fit, data.frame(Y, X))

## SHAP via DALEX, versatile but slow
choc_svm_exp <- explain(choc_svm_fit, data = X, y = Y,
                        label = "Chocolates, svm")
## Note that cheem expects a full [n, p] attribution space
chocolates_svm_shap <- matrix(NA, nrow(X), ncol(X)) ## init a df of the same structure
tictoc::tic("choc svm DALEX shap")
sapply(1:nrow(X), function(i)\{
  pps <- predict_parts_shap(choc_svm_exp, new_observation = X[i, ])
  ## Keep just the [n, p] local explanations
  chocolates_svm_shap[i, ] <<- tapply(
    pps$contribution, pps$variable, mean, na.rm = TRUE) \%>\% as.vector()
\})
chocolates_svm_shap <- as.data.frame(chocolates_svm_shap)
tictoc::toc() ## ~35-40 sec for me

if(F)\{ ## Don't accidentally save
  save(chocolates_svm_pred, file = "./data/chocolates_svm_pred.rda")
  save(chocolates_svm_shap, file = "./data/chocolates_svm_shap.rda")
  #usethis::use_data(chocolates_svm_pred)
  #usethis::use_data(chocolates_svm_shap)
\}
}\if{html}{\out{</div>}}

An object of class \code{data.frame} with 88 rows and 10 columns.
}
\usage{
chocolates_svm_pred

chocolates_svm_shap
}
\description{
Predictions and DALEX shap attribution of an svm model of Chocolate data
classifying type of chocolate (light/dark).
}
\examples{
library(cheem)

## Classification setup
X    <- chocolates[, 5:14]
Y    <- chocolates$Type
clas <- chocolates$Type

## Precomputed predictions and shap attribution
str(chocolates_svm_pred)
str(chocolates_svm_shap)

## Cheem
choc_chm <- cheem_ls(X, Y, chocolates_svm_shap,
                     chocolates_svm_pred, clas,
                     label = "Chocolates, SVM, shap")

## Save for use with shiny app (expects an rds file)
if(FALSE){ ## Don't accidentally save.
  saveRDS(choc_chm, "./chocolates_svm_shap.rds")
  run_app() ## Select the saved rds file from the data dropdown.
}

## Cheem visuals
if(interactive()){
  prim <- 1
  comp <- 2
  global_view(peng_chm, primary_obs = prim, comparison_obs = comp)
  bas <- sug_basis(peng_xgb_shap, prim, comp)
  mv  <- sug_manip_var(peng_xgb_shap, primary_obs = 1, comparison_obs = 2)
  ggt <- radial_cheem_tour(peng_chm, basis = bas, manip_var = mv)
  animate_plotly(ggt)
}
}
\keyword{datasets}
