% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_util.r
\name{rnorm_from}
\alias{rnorm_from}
\title{Draw new samples from the supplied data given its mean and covariances.}
\usage{
rnorm_from(
  data,
  n_obs = 1,
  var_coeff = 1,
  method = c("pearson", "kendall", "spearman")
)
}
\arguments{
\item{data}{A data.frame or matrix to sample from.}

\item{n_obs}{Number of new observations to draw. Defaults to 1.}

\item{var_coeff}{Variance coefficient, closer to 0 make points near the
median, above 1 makes more points further away from the median.
Defaults to 1.}

\item{method}{The method of the covariance matrix. Expects "person"
(continuous numeric), "kendall" or "spearman"
(latter two are ranked based ordinal).}
}
\value{
A data.frame, sampled observations given the means and covariance of
the data based on with column names kept.
}
\description{
Creates new observation of the data given its specific means and shapes.
typically applied to a cluster subset of data. \emph{ie} draw from cluster 'a',
then assign to cluster 'b'.
}
\examples{
library(cheem)

sub <- mtcars[mtcars$cyl == 6, ]
## Draw 3 new observations in the shape of 6 cylinder vehicles, with reduced variance.
rnorm_from(data = sub, n_obs = 3, var_coeff = .5)
}
\seealso{
Other cheem utility: 
\code{\link{as_logical_index}()},
\code{\link{color_scale_of}()},
\code{\link{contains_nonnumeric}()},
\code{\link{is_discrete}()},
\code{\link{is_diverging}()},
\code{\link{linear_tform}()},
\code{\link{logistic_tform}()},
\code{\link{problem_type}()},
\code{\link{sug_basis}()},
\code{\link{sug_manip_var}()}
}
\concept{cheem utility}
