\name{SensorNoiseModel-class}
\alias{SensorNoiseModel}
\alias{SensorNoiseModel-class}
\alias{defaultSensorNoiseModel}
\alias{noisef}
\alias{noisef,SensorNoiseModel-method}
\title{Method noisef.}
\usage{
  defaultSensorNoiseModel()

  SensorNoiseModel(...)
}
\arguments{
  \item{...}{parameters of constructor.}
}
\value{
  List of the default parameters.
}
\description{
  Method noisef.

  Class \code{SensorNoiseModel} simulates a degradation in
  the performance of an individual sensor by generating
  noise in the sensitivity coefficients. This class is a
  super-class of the class \code{Sensor}.

  Function to get default constructor parameters of class
  \code{\link{SensorNoiseModel}}.

  Constructor method of SensorNoiseModel Class.

  Wrapper function SensorNoiseModel.
}
\details{
  Slots of the class: \tabular{rl}{ \code{num} \tab Sensor
  number (\code{1:17}), which noise profile is used. The
  default value is \code{1}. \cr \code{gases} \tab Gas
  indices. \cr \code{ngases} \tab The number of gases. \cr
  \code{gnames} \tab Names of gases. \cr \code{concUnits}
  \tab Concentration units external to the model. \cr
  \code{concUnitsInt} \tab Concentration units internal for
  the model, values used to evaluate the statistics on
  coefficients. \cr \code{ssd} \tab Parameter of standard
  deviation used to generate the noise. The deault value is
  0.1. \cr \code{sntype} \tab Noise type
  (\code{randomWalk}). \cr \code{snf} \tab Scaling factor
  for the amplitude to generate the noise. The default
  value is \code{c(1, 1, 0.2)}. \cr \code{sndata} \tab The
  reference data of standard deviation values from UNIMAN
  dataset (see \code{\link{UNIMANsnoise}}). \cr }

  Methods of the class: \tabular{rl}{ \code{predict} \tab
  Generates noise vectors of a given length. \cr \code{ssd}
  \tab Gets the noise level. \cr \code{ssd<-} \tab Sets the
  noise level. \cr \code{ncoef} \tab Gets the number of
  coefficients. \cr }

  The \code{plot} method has three types (parameter
  \code{y}): \tabular{rl}{ \code{barplot} \tab (default)
  Shows distribution of sd values stored in slot
  \code{sndata}. \cr \code{noise} \tab Depicts the noise
  vectors generated by the model. \cr \code{walk} \tab
  Shows the random walk on a scatterplot for two given
  coefficients. \cr }
}
\examples{
# model: default initialization
sn <- SensorNoiseModel()

# get information about the model
show(sn)
print(sn)

plot(sn)  

# model: custom parameters
# - many sensors
sn <- SensorNoiseModel(ssd=0.5, num=1:17, gases=c(1, 2, 3))

print(sn)

plot(sn)

# method plot
#  - plot types 'y': barplot, noise, walk
sn <- SensorNoiseModel() # default model

plot(sn, "barplot", main="plot(sn, 'barplot')") 
# default plot type, i.e. 'plot(sn)' does the same plotting

plot(sn, "noise", main="plot(sn, 'noise')")

set.seed(6) # make results reproducible
plot(sn, "walk", n=100, k=5, main="plot(sn, 'walk', n=100, k=5)")
  
}
\seealso{
  \code{\link{UNIMANsnoise}}, \code{\link{Sensor}}
}

