% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_last_date.R
\name{get_last_date}
\alias{get_last_date}
\title{Get the last date from a phenology record}
\usage{
get_last_date(dates, first = FALSE)
}
\arguments{
\item{dates}{numeric vector of Julian dates (days of the year)}

\item{first}{boolean variable that can be set to TRUE to get the first, not
the last, date of the phenology record.}
}
\value{
the latest (earliest) date of the series, under the assumption that
the longest period without bloom can be interpreted as separating the
phenological seasons. This should be a reasonable assumption in most cases.
}
\description{
When looking at multi-year phenology records, it is normally obvious in
which year bloom occurred last. Determining this with an automated
procedure, however, is a bit tricky, when the range of phenological dates
spans across a calendar year transition. This function finds the latest
phenological date of the record. This is the date before the longest
phenological date gap.
}
\examples{


get_last_date(c(1,3,6,8,10,25))
get_last_date(c(345,356,360,365,2,5,7,10))
get_last_date(c(345,356,360,365,2,5,7,10),first=TRUE)

 
}
\author{
Eike Luedeling
}
\keyword{utility}

