% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_climate_scenarios.R
\name{plot_climate_scenarios}
\alias{plot_climate_scenarios}
\title{Plot multiple chilling scenario groups (or for other metrics)}
\usage{
plot_climate_scenarios(climate_scenario_list, metric, metric_label,
  year_name = "End_year", label_sides = "both", ylim = c(0, NA),
  reference_line = NULL, col_rect = NA, col_line = NA, hist_col = NA,
  texcex = 2, caption_above = FALSE, family = "serif")
}
\arguments{
\item{climate_scenario_list}{list of lists containing information about the chill scenarios.
These lists must have an element named 'data' which should contain a data.frame with a column
named the same as the 'metric' argument, which contains (numeric) information to be plotted.
Additional optional elements are 'time_series' (Boolean, indicating if a time series is to be plotted),
'labels' (vector of length 'length(data)' containing labels for the scenarios - if this is a time
series scenario, these must be numeric; if the data are not a time series, the labels aren't shown in the
plot, because there wouldn't normally be enough space - only numbers are shown there, and the legend
is provided in the value returned by this function), 'caption' (up to three character strings indicating
the caption to be displayed in the respective plot panel; the elements of this vector are displayed on
different lines. If caption_above==TRUE, only the first element is displayed) and 'historic_data'
(a data.frame containing at least two columns named the same as 'metric' and 'year_name').
documentation of 'make_chill_scenario_plot' for details on these.}

\item{metric}{character string corresponding to the name of the column that contains the data of
interest in the climate_scenario_list data.frames (and if applicable the historic_data data.frame).}

\item{metric_label}{character string specifying the y-axis label.}

\item{year_name}{character string indicating the name of the time column in the historic_data data.frame.}

\item{label_sides}{indicates what sides of the plot y-axis labels are to be drawn. Can be "left', "right"
or "both". If label_sides assumes any other value, no labels are plotted.}

\item{ylim}{numeric vector of length 2, specifying the lower and upper limits of the y-axis. If either of
these two values is NA, it is automatically selected based on the data range.}

\item{reference_line}{numeric vector of length 1, 2 or 3, specifying a horizontal reference bar to be drawn
across the plot (e.g. to indicate exceedance of a threshold). A reference_line argument of length 1 is
interpreted by drawing a line across the plot at the specified value. If length(reference_line)==2, the
values are interpreted as lower and upper limit of a rectangular threshold area. If
length(reference_line)==3, the lowest and highest values are used to draw a rectangle and the median value
to draw a line (e.g. to show a best estimate and a confidence interval around it).}

\item{col_rect}{color code or name for the color of the reference_line rectangle.}

\item{col_line}{color code or name for the color of the reference_line line.}

\item{hist_col}{color code or name for the color of the historic data points.}

\item{texcex}{numeric variable indicating character size (cex for all text elements in the plot).}

\item{caption_above}{Boolean variable indicating whether the caption should be drawn above (TRUE) or
inside the figure.}

\item{family}{character string specifying the font family ('serif', 'sans' or 'mono').}
}
\value{
List of legends for the different panels of the plot. This list reads 'time series labels'
for time series plot, 'no adequate labels provided' for unlabeled collections of boxplot, and a data.frame
explaining the number codes used as the legend in labeled collections of boxplots.
As a side effect, a plot of the climate scenarios is drawn.

The function generates errors, when problems arise.
}
\description{
For quantifying climate risks, it is useful to generate many version of plausible weather for
particular climate scenarios. This can, for example, be done with the temperature_generation function.
This function facilitates illustration of these results by providing various options to show them as
boxplots. The function can plot either a single panel of climate scenarios or multiple panels
side by side.
}
\examples{

  #making 3 identical objects as scenarios; let's assume these represent the
  #years 2000, 2005 and 2010. 
  
  models<-list(Chilling_Hours=Chilling_Hours,Utah_Chill_Units=Utah_Model,Chill_Portions=
     Dynamic_Model,GDH=GDH)
  
  chill<-tempResponse(stack_hourly_temps(
     fix_weather(KA_weather[which(KA_weather$Year>2003),]),latitude=50.4),
     Start_JDay = 305,End_JDay = 60,models)
  scenario_results<-list(chill,chill,chill)
  
  climate_scenario_list<-list(list(data=scenario_results,
                                   caption=c("Historic","data"),
                                   time_series=TRUE,
                                   labels=c(2000,2005,2010),
                                   historic_data=chill),
                              list(data=scenario_results,
                                   caption=c("Scenario","1"),
                                   labels=c("Climate model 1",
                                            "Climate model 2",
                                            "Climate model 3")),
                              list(data=scenario_results,
                                   caption=c("Scenario","2")),
                              list(data=scenario_results,
                                   caption=c("Scenario","3")))
                                   
                                   
 plot_climate_scenarios(climate_scenario_list,metric="Chill_Portions",
                                 metric_label="Chill Portions",
                                 year_name="End_year",label_sides="both",
                                 reference_line=c(40,45,50),col_rect=NA,col_line=NA,
                                 texcex=2,caption_above=FALSE)
                                 
 plot_climate_scenarios(climate_scenario_list,"Chill_Portions","Chill Portions",
    texcex=1)

  
 
}
\author{
Eike Luedeling
}
\keyword{utility}
