% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_daily_chill_plot.R
\name{make_daily_chill_plot2}
\alias{make_daily_chill_plot2}
\title{Plot daily climate metric accumulation throughout the year (2)}
\usage{
make_daily_chill_plot2(daily, metrics = NA, startdate = 1,
  enddate = 366, useyears = NA, metriclabels = NA,
  focusyears = "none", cumulative = FALSE, fix_leap = TRUE)
}
\arguments{
\item{daily}{an object generated with the daily_chill
function, which can calculate several standard chilling metrics or be
supplied with user-written temperature models. Since the format for the
input file must meet certain requirements, I recommend that you follow the
steps shown in the example below to prepare it.}

\item{metrics}{list of the metrics to be evaluated. This defaults to NA, in
which case the function makes a guess on what metrics you want to
calculated. This is done by choosing all column headers that are not
required for a daily_chill object.}

\item{startdate}{the first day of the season for which the metrics are to be
summarized (as a Julian date = day of the year)}

\item{enddate}{the last day of the season for which the metrics are to be
summarized (as a Julian date = day of the year)}

\item{useyears}{if only certain years are to be used, these can be provided
here as a numeric vector. Defaults to NA, which means all years in the
daily_chill object are used.}

\item{metriclabels}{Character vector with labels for each metric to be
analyzed. Defaults to NA, which means that the strings passed as metrics
will be used.}

\item{focusyears}{Numeric vector containing the years that are to be
highlighted in the plot. Years for which no data are available are
automatically removed.}

\item{cumulative}{Boolean argument (TRUE or FALSE) indicating whether the
climate metric should be shown as daily accumulation rates or as cumulative
accumulation.}

\item{fix_leap}{boolean parameter indicating whether the anomaly that can
originate when leaf years are present in the data should be smoothed by
interpolating between Dec 30 and Jan 1 in leap years.}
}
\value{
The main purpose of the function is a side effect - plots of daily
climate metric accumulation. However, all the data used for making the plots
is returned as a list containing an element for each metric, which consists
of a data.table with the daily means, standard deviation and daily values
for all focusyears.
}
\description{
This function generates a plot of the accumulation of a climate metric
throughout the year. Its standard output are the mean daily accumulation and
the standard deviation. It is also possible to add one or several so-called
focusyears to add the daily accumulation during these years to the plots.
Plots can be produced in R or directly exported as .png files.
}
\details{
Plots daily accumulation of climatic metrics, such as winter chill, as daily
accumulation rates or as cumulative accumulation. A legend is only added,
when focusyears are also shown. Otherwise the plot is reasonably
self-explanatory.
}
\examples{


daily<-daily_chill(stack_hourly_temps(fix_weather(
  KA_weather[which(KA_weather$Year>2005),])),running_mean=11)

make_daily_chill_plot2(daily,metrics=c("Chill_Portions","GDH"),cumulative=TRUE,
   startdate=300,enddate=30,focusyears=c(2009,2008))


 
}
\author{
Eike Luedeling
}
\keyword{utility}
