% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenologyFitter.R
\name{phenologyFitter}
\alias{phenologyFitter}
\title{phenologyFitter}
\usage{
phenologyFitter(
  par.guess = NULL,
  modelfn = PhenoFlex_GDHwrapper,
  bloomJDays,
  SeasonList,
  control = list(smooth = FALSE, verbose = TRUE, maxit = 1000, nb.stop.improvement =
    250),
  lower,
  upper,
  seed = 1235433,
  ...
)
}
\arguments{
\item{par.guess}{numeric vector. Initial guesses for fit parameters. This can be set to
`NULL`, in which case `GenSA` choses initial parameters.}

\item{modelfn}{function. Model function which computes the index in `temperatures` at
which blooming occures. It must have as first argument a data frame with at least the
two columns `Temp` and `JDays` for one season, see `SeasonList`. It can have further
arguments which can be passed via `...`. The `modelfn` must return a single numeric value
for the predicted bloom JDay for that season. `NA` is an allowed return value if no blooming
occures in that season.
The default is the \link{PhenoFlex} with GDH as heat accumulation. Alternative is
\link{PhenoFlex_GAUSSwrapper} with GAUSSian heat accumulation. But this function can also be user
defined.}

\item{bloomJDays}{integer vector. vector of observed bloom JDays per year}

\item{SeasonList}{list. Must be a list of data frames, each data frame for one season. Each data.frame
must at least have a column `Temp` with the temperature vector and `JDays` with the corresponding
JDay vector. Can be generated by e.g. \link{genSeasonList}.
`length(SeasonList)` must be equal to `length(bloomJDays)`.}

\item{control}{control parameters to `GenSA`, see `GenSA::GenSA`}

\item{lower}{Vector with length of ‘par.guess’. Lower bounds for components.}

\item{upper}{Vector with length of ‘par.guess’. Upper bounds for components.}

\item{seed}{integer seed for the random number generator used by `GenSA`.}

\item{...}{further parameters to be passed on to `modelfn`.}
}
\value{
an object of class `phenologyFit`. It contains the named elements `model_fit` with
the returned object from GenSA, `par` the best fit parameters, `pbloomJDays` the
predicted bloom JDays and the inputs
`par.guess`, `modelfn`, `bloomJDays`, `lower`, `upper`, `control`, `SeasonList` and
`...`.
}
\description{
phenologyFitter
}
\examples{
## this example does not make sense as a fit, but demonstrates
## how to use `phenologyFitter`
data(KA_weather)
data(KA_bloom)
hourtemps <- stack_hourly_temps(KA_weather, latitude=50.4)
SeasonList <- genSeasonList(hourtemps$hourtemps, years=c(2007,2008))
par <- c(40, 190, 0.5, 25, 3372.8, 9900.3, 6319.5, 5.939917e13, 4, 36, 4, 1.6)
upper <- c(41, 200, 1, 30, 4000, 10000, 7000, 6.e13, 10, 40, 10, 50)
lower <- c(38, 180, 0.1, 0, 3000, 9000, 6000, 5.e13, 0, 0, 0, 0.05)
X <- phenologyFitter(par.guess=par, bloomJDays=KA_bloom$pheno[c(24,25)], 
  SeasonList=SeasonList, lower=lower, upper=upper,
  control=list(smooth=FALSE, verbose=TRUE, maxit=10, nb.stop.improvement=5))
summary(X)
plot(X)
}
\author{
Carsten Urbach <urbach@hiskp.uni-bonn.de>
}
