% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scancn.R
\name{scancn}
\alias{scancn}
\title{Read a Text File by Auto-Detecting Encoding}
\usage{
scancn(x, enc = "auto", read_2nd = TRUE)
}
\arguments{
\item{x}{a length 1 character specifying filename.}

\item{enc}{a length 1 character of file encoding specified by user. The default is "auto", which 
means let the function detect encoding.}

\item{read_2nd}{should be \code{TRUE} (default) or \code{FALSE}. When it is \code{TRUE}, 
some files will be read twice, see Details.}
}
\value{
a length 1 character of text.
}
\description{
The function reads a text file and tries to detect file encoding. If you have Chinese files from 
different sources and cannot give them a single encoding, just let this function detect and 
read them. The function can save you much time on dealing with unrecognizable characters.
}
\details{
The function calls \code{scan(x, what= "character", ...)} and auto-detects file 
encoding. Sometimes 
a Chinese file is encoded in "UTF-8", but what is actually read is a "?". When this happens, 
the function reads it twice and uses \code{\link[stringi]{stri_encode}} to convert it.

The function always returns a length 1 character. If the return of \code{scan} is a vector 
with length larger than 1, 
elements will be pasted together with three spaces.

It will return 
 a " " (one space) when all the elements of the vector are \code{NA}.
If not all elements 
are \code{NA}, those equal to \code{NA} will be changed to "" (a size 0 string) before being 
pasted together.
}
\examples{
# No Chinese is allowed, so try an English file
x <- file.path(find.package("base"), "CITATION")
scancn(x)
}
