% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chirps.R
\docType{package}
\name{chirps}
\alias{chirps}
\alias{chirps-package}
\title{API Client for CHIRPS}
\description{
\if{html}{\figure{logo.png}{options: align='right' alt='logo' width='120'}}

API Client for the Climate Hazards Group InfraRed Precipitation
  with Station Data 'CHIRPS'. The 'CHIRPS' data is a 35+ year quasi-global
  rainfall data set, which incorporates 0.05 arc-degrees resolution satellite
  imagery, and in-situ station data to create gridded rainfall time series for
  trend analysis and seasonal drought monitoring. For more details on 'CHIRPS'
  data please visit its official home page <https://www.chc.ucsb.edu/data/chirps>.
  Requests from large time series (> 10 years) and large geographic coverage 
  (global scale) may take several minutes.
}
\note{
While chirps does not redistribute the data or provide it in any way, 
 we encourage users to cite Funk et al. (2015) when using the CHIRPS data.

Funk C., et al. (2015). Scientific Data, 2, 150066. 
\url{https://doi.org/10.1038/sdata.2015.66}
}
\seealso{
\strong{Useful links:}
\itemize{
\item{JOSS paper: 
 \url{https://doi.org/10.21105/joss.02419}}
\item{Development repository: 
 \url{https://github.com/ropensci/chirps}}
\item{Static documentation: 
 \url{https://docs.ropensci.org/chirps/}}
\item{Report bugs: 
 \url{https://github.com/ropensci/chirps/issues}}
\item{CHIRPS website: 
 \url{https://www.chc.ucsb.edu/data/chirps}}
\item{ClimateSERV website: 
 \url{https://climateserv.servirglobal.net/}}
}
}
\author{
Kauê de Sousa and Adam H. Sparks
}
