% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-lgl.R
\name{chk_lgl}
\alias{chk_lgl}
\alias{vld_lgl}
\title{Check Logical Scalar}
\usage{
chk_lgl(x, x_name = NULL)

vld_lgl(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if logical scalar using

\code{is.logical(x) && length(x) == 1L}
}
\section{Functions}{
\itemize{
\item \code{vld_lgl}: Validate Logical Scalar
}}

\examples{
# chk_lgl
chk_lgl(NA)
try(chk_lgl(1))
# vld_lgl
vld_lgl(TRUE)
vld_lgl(FALSE)
vld_lgl(NA)
vld_lgl(1)
vld_lgl(c(TRUE, TRUE))
}
\seealso{
Other chk_logical: 
\code{\link{chk_false}()},
\code{\link{chk_flag}()},
\code{\link{chk_true}()}
}
\concept{chk_logical}
