% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDelaunay.R
\name{addDelaunay}
\alias{addDelaunay}
\title{Add Delaunay triangles.}
\usage{
addDelaunay(pump.select = NULL, vestry = FALSE, color = "black",
  line.type = "solid", line.width = 1, latlong = FALSE)
}
\arguments{
\item{pump.select}{Numeric. Default is NULL; all pumps are used. Otherwise, selection by a vector of numeric IDs: 1 to 13 for \code{pumps}; 1 to 14 for \code{pumps.vestry}. Exclusion (negative selection) is possible (e.g., -6).}

\item{vestry}{Logical. \code{FALSE} for original 13 pumps. TRUE for 14 pumps in Vestry Report.}

\item{color}{Character. Color of triangle edges.}

\item{line.type}{Character. Type of line for triangle edges.}

\item{line.width}{Numeric. Width of cell edges: lwd.}

\item{latlong}{Logical. Use estimated longitude and latitude.}
}
\description{
Add Delaunay triangles.
}
\note{
This function uses \code{deldir::deldir()}.
}
\examples{
snowMap()
addDelaunay()
}
