% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_spectrum.R
\name{plot_spectrum}
\alias{plot_spectrum}
\title{Plot spectrum from peak table}
\usage{
plot_spectrum(
  loc,
  peak_table,
  chrom_list,
  chr = "max",
  lambda = "max",
  plot_spectrum = TRUE,
  plot_trace = TRUE,
  spectrum_labels = TRUE,
  scale_spectrum = FALSE,
  export_spectrum = FALSE,
  verbose = TRUE,
  what = c("peak", "rt", "click"),
  ...
)
}
\arguments{
\item{loc}{The name of the peak or retention time for which you wish to
extract spectral data.}

\item{peak_table}{The peak table (output from \code{\link{get_peaktable}}
function).}

\item{chrom_list}{A list of chromatograms in matrix form (timepoints x
wavelengths).}

\item{chr}{Numerical index of chromatogram you wish to plot, or "max" to
automatically plot the chromatogram with the largest signal.}

\item{lambda}{The wavelength you wish to plot the trace at if plot_trace ==
TRUE and/or the wavelength to be used for the determination of signal
abundance.}

\item{plot_spectrum}{Logical. If TRUE, plots the spectrum of the chosen
peak. Defaults to TRUE.}

\item{plot_trace}{Logical. If TRUE, plots the trace of the chosen peak at
lambda. Defaults to TRUE.}

\item{spectrum_labels}{Logical. If TRUE, plots labels on maxima in spectral
plot. Defaults to TRUE.}

\item{scale_spectrum}{Logical. If TRUE, scales spectrum to unit height.
Defaults to FALSE.}

\item{export_spectrum}{Logical. If TRUE, exports spectrum to console.
Defaults to FALSE.}

\item{verbose}{Logical. If TRUE, prints verbose output to console. Defaults
to TRUE.}

\item{what}{What to look for. Either "peak" to extract spectral information
for a certain peak, "rt" to scan by retention time, or "click" to manually
select retention time by clicking on the chromatogram. Defaults to "peak"
mode.}

\item{...}{Additional arguments.}
}
\value{
If \code{export_spectrum} is TRUE, returns the spectrum as a \code{
data.frame} with wavelengths as rows and a single column encoding the
absorbance (or normalized absorbance, if \code{scale_spectrum} is TRUE)
at each wavelength. Otherwise, there is no return value.
}
\description{
Plots the trace and/or spectrum for a given peak in peak.table object, or
plots the spectrum a particular retention time for a given chromatogram.
}
\details{
Can be used to confirm the identity of a peak or check that a particular
column in the peak table represents a single compound. Retention times can
also be selected by clicking on the plotted trace if what == 'click'.
}
\section{Side effects}{

If \code{plot_trace} is TRUE, plots the chromatographic trace of the specified
chromatogram (\code{chr}), at the specified wavelength (\code{lambda}) with a
dotted red line to indicate the retention time given by \code{loc}. The
trace is a single column from the chromatographic matrix.

If \code{plot_spectrum} is TRUE, plots the spectrum for the specified chromatogram
at the specified retention time. The spectrum is a single row from the chromatographic
matrix.
}

\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontshow{\}) # examplesIf}
}
\author{
Ethan Bass
}
