% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enchunk.R
\name{add_chunk}
\alias{add_chunk}
\title{Transforms a function call into an Rmarkdown chunk}
\usage{
add_chunk(
  report = "",
  dt_expr = NULL,
  fun,
  params,
  chunk_title = NULL,
  title_level = 2,
  echo = FALSE,
  message = FALSE,
  warning = FALSE,
  fig_width = NULL,
  fig_height = NULL
)
}
\arguments{
\item{report}{Character string containing the text of an Rmarkdown report header (and possibly more chunks). Easily create one with chronicle::new_report(), and if NULL, this will be the default value.}

\item{dt_expr}{Name of the table to run fun on.}

\item{fun}{Function to call.}

\item{params}{List of parameters to be passed to fun.}

\item{chunk_title}{Title of the Rmarkdown chunk. If NULL, chronicle will try to parse a generic title based on the function and parameters passed using make_title()}

\item{title_level}{Level of the section title of this plot (ie, number of # on Rmarkdown syntax.)}

\item{echo}{Whether to display the source code in the output document. Default is FALSE.}

\item{message}{Whether to preserve messages on rendering. Default is FALSE.}

\item{warning}{Whether to preserve warnings on rendering. Default is FALSE.}

\item{fig_width}{Width of the plot (in inches).}

\item{fig_height}{Height of the plot (in inches).}
}
\value{
An rmarkdown chunk as a character string.
}
\description{
Transforms a function call into an Rmarkdown chunk
}
\examples{
library(chronicle)
html_chunk <- add_chunk(fun = make_barplot,
                        dt = 'iris',
                        params = list(value = 'Sepal.Width',
                                      bars = 'Species'))
cat(html_chunk)
}
