% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{mapplot}
\alias{mapplot}
\alias{mapplot,RasterLayer-method}
\alias{mapplot,RasterStack-method}
\alias{mapplot,RasterArray-method}
\alias{mapplot,SpatialPolygonsDataFrame-method}
\alias{mapplot,SpatialPolygons-method}
\title{Wrapper function to plot maps of different classes}
\usage{
mapplot(x, ...)

\S4method{mapplot}{RasterLayer}(
  x,
  col = "gradinv",
  axes = FALSE,
  box = FALSE,
  legend = FALSE,
  legend.title = NULL,
  ...
)

\S4method{mapplot}{RasterStack}(x, col = gradinv(255), ...)

\S4method{mapplot}{RasterArray}(
  x,
  col = "gradinv",
  rgb = FALSE,
  legend = FALSE,
  axes = FALSE,
  box = FALSE,
  ncol = 3,
  legend.title = NULL,
  plot.title = NULL,
  rowlabels = rownames(x),
  multi = FALSE,
  ask = FALSE,
  ...
)

\S4method{mapplot}{SpatialPolygonsDataFrame}(x, col = "lightgrey", ...)

\S4method{mapplot}{SpatialPolygons}(x, col = "lightgrey", ...)
}
\arguments{
\item{x}{Object to be plotted}

\item{...}{arguments passed to class-specific methods.}

\item{col}{(\code{character}) Color or color scheme of the plot. See \code{\link{ramps}} for available palettes (\code{ipccLine} and \code{ipccRCP} are not available).}

\item{axes}{(\code{logical}) Should axes be displayed?}

\item{box}{(\code{logical}) Should bounding boxes be displayed?}

\item{legend}{(\code{logical}) Triggers whether the legend of a \code{\link[raster:raster]{RasterLayer}} would be plotted.}

\item{legend.title}{(\code{character}) Title for the legend, if \code{legend = TRUE}.}

\item{rgb}{set to (\code{TRUE}) to make a red-green-blue plot based on three layers or bands.}

\item{ncol}{\code{numeric}) Set number of columns in a multi-plot for a single variable. For a \code{\link[chronosphere:RasterArray-class]{RasterArray}} with multiple variables, this number is automatically set to the number of variables.}

\item{plot.title}{(\code{character}) The title for each individual plot. Only available for a single variable at the moment.}

\item{rowlabels}{(\code{character}) label for each row of the overall plot. Uses the rownames of the \code{\link[chronosphere:RasterArray-class]{RasterArray}} by default. Only availble for multivariate \code{\link[chronosphere:RasterArray-class]{RasterArray}}s.}

\item{multi}{(\code{logical}) Should the plots be printed on multiple pages?}

\item{ask}{(\code{logical} or \code{NULL}) If \code{multi.page = TRUE} and \code{ask = TRUE}, then the user will be prompted before a new page of output is started}
}
\value{
None.
}
\description{
This function plots Raster and sp-type objects.
}
\examples{

 #single variable
	data(dems)
	mapplot(dems, ncol=4)
	
	#multiple variables
	data(clim)
	mapplot(clim, multi=TRUE, legend=TRUE)
}
