% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetching.R
\name{fetch}
\alias{fetch}
\title{Data fetching}
\usage{
fetch(
  dat,
  var = NULL,
  ver = NULL,
  res = NULL,
  datadir = NULL,
  verbose = TRUE,
  call = FALSE,
  call.expr = FALSE,
  ...
)
}
\arguments{
\item{dat}{(\code{character}) The dataset to get variables from.}

\item{var}{(\code{character}) Vector of variable names to get.}

\item{ver}{(\code{character}) The version of the variable. Defaults to \code{NULL}, which will download the latest available version. We have to create a data table, which should be part of the package. This has to be searched for valid argument combinations. Right this is just a folder with a date.}

\item{res}{(\code{character} or \code{numeric}) The resolution of raster layers. This has to be the same for all RasterLayers that make up the variable.}

\item{datadir}{(\code{character}) Directory where downloaded files are kept. Individual layers will be looked up from the directory if this is given, and will be downloaded if they are not found. The default \code{NULL} option will download data to a temporary directory that exists only until the R session ends.}

\item{verbose}{(\code{logical}) Should console feedback during download be displayed?}

\item{call}{(\code{logical}) If set to \code{TRUE} the function call is returned instead of the object.}

\item{call.expr}{(\code{logical}) If \code{call} is set to \code{TRUE}, then should the call be returned as an \code{expression} (\code{TRUE}) or a message (\code{FALSE})?}

\item{...}{Arguments passed to variable-specific loading functions.}
}
\value{
An object that matches the 'type' field of the varibles in the output of the \code{\link{datasets}} function.
}
\description{
Function to download and attach variables in the \code{chronosphere} package
}
\details{
Use the function \code{\link{datasets}} to find available variables.
}
\examples{
\donttest{
	a <- fetch(dat="paleomap", var="dem")
}
}
