% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetching.R
\name{fetch}
\alias{fetch}
\title{Fetching data items}
\usage{
fetch(
  src = NULL,
  ser = NULL,
  ver = NULL,
  res = NULL,
  ext = NULL,
  class = NULL,
  item = NULL,
  datadir = NULL,
  verbose = TRUE,
  call = FALSE,
  call.expr = FALSE,
  attach = TRUE,
  ...
)
}
\arguments{
\item{src}{(\code{character}) The source of the series.}

\item{ser}{(\code{character}) The series to get.}

\item{ver}{(\code{character}) The version of the product to download. Defaults to \code{NULL}, which will download the latest available version.}

\item{res}{(\code{character} or \code{numeric}) The resolution string of the data.}

\item{ext}{(\code{character}) File extension of the used data file.}

\item{class}{(\code{character}) Class of the returned object, if not the default.}

\item{item}{(\code{numeric}) The item ID that is to be downloaded. This setting overrides all other identifiers.}

\item{datadir}{(\code{character}) Directory where downloaded files are kept. Individual items will be looked up from the directory if this is given, and will be downloaded if they are not found. The default \code{NULL} option will download data to a temporary directory that exists only until the R session ends.}

\item{verbose}{(\code{logical}) Should console feedback during download be displayed?}

\item{call}{(\code{logical}) If set to \code{TRUE} the function call is returned instead of the object.}

\item{call.expr}{(\code{logical}) If \code{call} is set to \code{TRUE}, then should the call be returned as an \code{expression} (\code{TRUE}) or a message (\code{FALSE})?}

\item{attach}{(\code{logical}) If the item has required packages, should these be attached?}

\item{...}{Arguments passed to item-specific loading functions.}
}
\value{
An object from a class that matches the 'class' coordinate of the item.
}
\description{
Function to download and attach items from the \code{chronosphere} archives
}
\details{
Use the function \code{\link{datasets}} to find available series.
}
\examples{
# An actual download call
# a <- fetch(src="paleomap", ser="dem")
# A locally-present object, in package's directory
a <- fetch(src="SOM-zaffos-fragmentation",
  datadir=system.file("extdata", package="chronosphere"))
# call repetition
fetch(a, call=TRUE)
}
