`cir.upndown` <-
function(yesno,xseq,target,xbounds=c(0,1),ybounds=c(0,1),
    full=FALSE,cioption="poisson",plist=c(.025,.975)) {
# Centered-isotonic-regression for Up-and-Down
# Assaf Oron, 10/2007
# Returns Point & Interval Estimates of Target percentile

### ARGUMENTS:
# yesno: Yes-no table of binary responses. Can contain rows of zeros
# xseq: Treatment values matched to the responses
# target: The target response rate (between 0 and 1)
# xbounds,ybounds: used for interpolation in case (estimated)
# target falls outside CIR output boundaries.
# full: complete output or estimates only
# cioption: which method to use for interval estimation
# can choose from 'poisson', 't' or binomial (any other string)
# plist: percentile list for interval estimation. Is a vector
# of any length

n_m<-yesno[,1]+yesno[,2]
x<-xseq[n_m>0]
y<-yesno[n_m>0,1]/n_m[n_m>0]

xbounds[1]<-min(xbounds[1],min(x))
xbounds[2]<-max(xbounds[2],max(x))

### Point Estimate  ###########################

# We start via forward estimation, just calling 'cir.pava'

pavout<-cir.pava(y,x,wt=n_m[n_m>0],full=TRUE)

newx<-pavout$alg.x
newy<-pavout$alg.y
newn=pavout$alg.wt

### Error control if the interpolation target is outside boundary
if (min(newy)>target) {
    newx<-c(xbounds[1],pavout$alg.x)
    newy=c(ybounds[1],pavout$alg.y)
    newy=c(ybounds[1],pavout$alg.y)
    newn<-c(1,pavout$alg.wt)
}
mm=length(newy)
if (max(newy)<target) {
    newx<-c(newx,xbounds[2])
    newy=c(newy,ybounds[2])
    newn=c(newn,1)
}
### The estimate is generated by using 'approx' with x and y interchanged

out=ifelse(length(newy)==1,newx,approx(x=newy,y=newx,
    xout=target,ties="ordered",rule=2)$y)

### Now to Interval Estimate ###########################

# We find the point estimate's location w.r.t. our grid

offset=0
yplace=match(target,newy)

if (!is.na(yplace)) {
    minn=newn[yplace]
    offset=1
} else {
    yplace=min(max(rank(c(target,newy),ties.method="min")[1]-1,1),length(newy)-1)
    minn=min(newn[yplace],newn[yplace+1],na.rm=TRUE)
}
if (length(newy)==1 || newy[yplace+1]==newy[yplace])  {
### degenerate cases (error control)

    cigaps=ifelse(plist<0.5,xbounds[1]-xbounds[2],xbounds[2]-xbounds[1])
#   }
} else {

    if (cioption=='poisson') { 
        width=smoothqpois(plist,minn,target)/minn-target

    } else width=smoothqbinom(plist,minn,target)/minn-target

### Inverting the forward interval estimates

    cigaps=width*(newx[yplace+1]-newx[yplace-offset])/(newy[yplace+1]-newy[yplace-offset])
}

#### Output

if (!full) { return(c(out,out+cigaps)) 
} else return (list(raw=yesno,paved=pavout,out=out,ci=out+cigaps))
}

