% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circGLMClassFunctions.R
\name{residuals.circGLM}
\alias{residuals.circGLM}
\title{Obtain residuals from a circGLM object}
\usage{
\method{residuals}{circGLM}(object, type = "arc", ...)
}
\arguments{
\item{object}{A \code{circGLM} object.}

\item{type}{Either \code{"arc"} or \code{"cosine"}, the type of distance to
take.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A numeric vector of residuals. If type is \code{"arc"}, these are
  angles in radians. If type is \code{"cosine"}, these are numeric values
  between 0 and 2.
}
\description{
Computes the residuals either by taking the arc distance or the cosine
distance between the predictions and the observed outcomes.
}
\examples{
m <- circGLM(th = rvmc(10, 0, 1))
residuals(m)

# Cosine residuals
residuals(m, type = "cosine")

}
