% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell-geom.R
\name{ccPolygon}
\alias{ccPolygon}
\title{Draw polygon}
\usage{
ccPolygon(x = NULL, y = NULL, ...)
}
\arguments{
\item{x}{Data points on x-axis}

\item{y}{Data points on y-axis}

\item{...}{pass to \code{\link[graphics]{polygon}}}
}
\value{
Object \linkS4class{ccCellGeom}
}
\description{
Object \linkS4class{ccCellGeom} will call the function \link[circlize:circos.polygon]{circlize::circos.polygon} while drawing.
}
\examples{
library(circlizePlus)
cc <- ccPlot(sectors = letters[1:8], xlim = c(0, 1))
track <- ccTrack(ylim = c(0, 10))
cell <- ccCell(sector.index = "a") + ccPolygon(x = c(0.5, 0.7, 1), y = c(2, 6, 8))
track <- track + cell
cc + track
}
