% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidying_functions.R
\name{ipsatize}
\alias{ipsatize}
\title{Ipsatize circumplex items using deviation scoring across variables}
\usage{
ipsatize(.data, items, na.rm = TRUE, overwrite = FALSE)
}
\arguments{
\item{.data}{Required. A data frame containing at least circumplex scales.}

\item{items}{Required. The variable names or column numbers for the
variables in \code{.data} that contain circumplex items to be ipsatized.}

\item{na.rm}{Optional. A logical that determines whether missing values
should be ignored during the calculation of the mean during ipsatization
(default = TRUE).}

\item{overwrite}{Optional. A logical that determines whether the variables
specified in \code{items} should be overwritten with ipsatized versions
or alternatively preserved and new variables ending with "_i" should be
added to the data frame (default = FALSE).}
}
\value{
A data frame that matches \code{.data} except that the variables
specified in \code{items} have been rescored using ipsatization.
}
\description{
Rescore each circumplex item using deviation scoring across variables. In
other words, subtract each observation's mean response from each response.
This effectively removes the presence of a general factor, which can make
certain circumplex fit analyses more powerful.
}
\examples{
data("raw_iipsc")
ipsatize(raw_iipsc, IIP01:IIP32)
}
\seealso{
Other tidying functions: 
\code{\link{score}()},
\code{\link{standardize}()}
}
\concept{tidying functions}
