% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{models_list}
\alias{models_list}
\title{List}
\usage{
models_list(
  model_name = NULL,
  training_table_name = NULL,
  dependent_variable = NULL,
  author = NULL,
  status = NULL,
  hidden = NULL,
  archived = NULL,
  limit = NULL,
  page_num = NULL,
  order = NULL,
  order_dir = NULL
)
}
\arguments{
\item{model_name}{string optional. If specified, will be used to filter the models returned. Substring matching is supported. (e.g., "modelName=model" will return both "model1" and "my model").}

\item{training_table_name}{string optional. If specified, will be used to filter the models returned by the training dataset table name. Substring matching is supported. (e.g., "trainingTableName=table" will return both "table1" and "my_table").}

\item{dependent_variable}{string optional. If specified, will be used to filter the models returned by the dependent variable column name. Substring matching is supported. (e.g., "dependentVariable=predictor" will return both "predictor" and "my predictor").}

\item{author}{string optional. If specified, return models from this author. It accepts a comma-separated list of author ids.}

\item{status}{string optional. If specified, returns models with one of these statuses. It accepts a comma-separated list, possible values are 'running', 'failed', 'succeeded', 'idle', 'scheduled'.}

\item{hidden}{boolean optional. If specified to be true, returns hidden items. Defaults to false, returning non-hidden items.}

\item{archived}{string optional. The archival status of the requested item(s).}

\item{limit}{integer optional. Number of results to return. Defaults to its maximum of 50.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to updated_at. Must be one of: updated_at, name, created_at, last_run.updated_at.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to desc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The ID of the model.}
\item{tableName}{string, The qualified name of the table containing the training set from which to build the model.}
\item{databaseId}{integer, The ID of the database holding the training set table used to build the model.}
\item{credentialId}{integer, The ID of the credential used to read the target table. Defaults to the user's default credential.}
\item{modelName}{string, The name of the model.}
\item{description}{string, A description of the model.}
\item{interactionTerms}{boolean, Whether to search for interaction terms.}
\item{boxCoxTransformation}{boolean, Whether to transform data so that it assumes a normal distribution. Valid only with continuous models.}
\item{modelTypeId}{integer, The ID of the model's type.}
\item{primaryKey}{string, The unique ID (primary key) of the training dataset.}
\item{dependentVariable}{string, The dependent variable of the training dataset.}
\item{dependentVariableOrder}{array, The order of dependent variables, especially useful for Ordinal Modeling.}
\item{excludedColumns}{array, A list of columns which will be considered ineligible to be independent variables.}
\item{limitingSQL}{string, A custom SQL WHERE clause used to filter the rows used to build the model. (e.g., "id > 105").}
\item{crossValidationParameters}{list, Cross validation parameter grid for tree methods, e.g. {"n_estimators": [100, 200, 500], "learning_rate": [0.01, 0.1], "max_depth": [2, 3]}.}
\item{numberOfFolds}{integer, Number of folds for cross validation. Default value is 5.}
\item{schedule}{list, A list containing the following elements: 
\itemize{
\item scheduled boolean, If the item is scheduled.
\item scheduledDays array, Day based on numeric value starting at 0 for Sunday.
\item scheduledHours array, Hours of the day it is scheduled on.
\item scheduledMinutes array, Minutes of the day it is scheduled on.
\item scheduledRunsPerHour integer, Alternative to scheduled minutes, number of times to run per hour.
}}
\item{parentId}{integer, The ID of the parent job that will trigger this model.}
\item{timeZone}{string, The time zone of this model.}
\item{lastRun}{list, A list containing the following elements: 
\itemize{
\item id integer, 
\item state string, 
\item createdAt string, The time that the run was queued.
\item startedAt string, The time that the run started.
\item finishedAt string, The time that the run completed.
\item error string, The error message for this run, if present.
}}
\item{user}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{createdAt}{string, The time the model was created.}
\item{updatedAt}{string, The time the model was updated.}
\item{currentBuildState}{string, The status of the current model build. One of "succeeded", "failed", "queued", or "running,"or "idle", if no build has been attempted.}
\item{currentBuildException}{string, Exception message, if applicable, of the current model build.}
\item{builds}{array, An array containing the following fields: 
\itemize{
\item id integer, The ID of the model build.
\item name string, The name of the model build.
\item createdAt string, The time the model build was created.
\item description string, A description of the model build.
\item rootMeanSquaredError number, A key metric for continuous models. Nil for other model types.
\item rSquaredError number, A key metric for continuous models. Nil for other model types.
\item rocAuc number, A key metric for binary, multinomial, and ordinal models. Nil for other model types.
}}
\item{predictions}{array, An array containing the following fields: 
\itemize{
\item id integer, The ID of the model to which to apply the prediction.
\item tableName string, The qualified name of the table on which to apply the predictive model.
\item primaryKey array, The primary key or composite keys of the table being predicted.
\item limitingSQL string, A SQL WHERE clause used to scope the rows to be predicted.
\item outputTable string, The qualified name of the table to be created which will contain the model's predictions.
\item state string, The status of the prediction. One of: "succeeded", "failed", "queued", or "running,"or "idle", if no build has been attempted.
}}
\item{lastOutputLocation}{string, The output JSON for the last build.}
\item{archived}{string, The archival status of the requested item(s).}
}
\description{
List
}
