% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{imports_put_transfer}
\alias{imports_put_transfer}
\title{Transfer ownership of this object to another user}
\usage{
imports_put_transfer(
  id,
  user_id,
  include_dependencies,
  email_body = NULL,
  send_email = NULL
)
}
\arguments{
\item{id}{integer required. The ID of the resource that is shared.}

\item{user_id}{integer required. ID of target user}

\item{include_dependencies}{boolean required. Whether or not to give manage permissions on all dependencies}

\item{email_body}{string optional. Custom body text for e-mail sent on transfer.}

\item{send_email}{boolean optional. Send email to the target user of the transfer?}
}
\value{
A list containing the following elements:
\item{dependencies}{array, An array containing the following fields: 
\itemize{
\item objectType string, Dependent object type
\item fcoType string, Human readable dependent object type
\item id integer, Dependent object ID
\item name string, Dependent object name, or nil if the requesting user cannot read this object
\item permissionLevel string, Permission level of target user (not user's groups) for dependent object, or null if no target user
\item shared boolean, Whether dependent object was successfully shared with target user
}}
}
\description{
Transfer ownership of this object to another user
}
