% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmle_parallel.R
\name{tmle_parallel}
\alias{tmle_parallel}
\title{Modify TMLE to support parallel computation for g and Q.}
\usage{
tmle_parallel(Y, A, W, family, g.SL.library, Q.SL.library, id = 1:length(Y),
  verbose = F, V = 5, sl_fn = SuperLearner::SuperLearner,
  cvsl_fn = SuperLearner::CV.SuperLearner, cvQinit = F,
  conserve_memory = T, ...)
}
\arguments{
\item{Y}{Outcome}

\item{A}{Treatment indicator}

\item{W}{Covariates}

\item{family}{Gaussian or binomial}

\item{g.SL.library}{SL library for estimating g}

\item{Q.SL.library}{SL library for estimating Q}

\item{id}{Optional list of subject-specific ids.}

\item{verbose}{If TRUE outputs additional information during execution.}

\item{V}{Number of cross-validation folds to use when estimating g and Q.
Defaults to 5 as tmle package does.}

\item{sl_fn}{SuperLearner function to use for estimation of g and possibly Q.
By default this uses the normal SuperLearner function which is sequential.
Other options would be to pass in mcSuperLearner, snowSuperLearner, or
CV.SuperLearner. For functions that require additional arguments (e.g. the
cluster argument of for snowSuperLearner) one should create a new function
that overloads the call and sets that argument. This is what
setup_parallel_tmle() does.}

\item{cvsl_fn}{CV.SuperLearner equivalent, can be used for estimating Q.}

\item{cvQinit}{If T, estimate Q using cvsl_fn, otherwise use sl_fn.}

\item{conserve_memory}{If T, remove the fitLibrary elements to save memory
after we have done the relevant prediction.}

\item{...}{Remaining arguments are passed through to tmle::tmle().}
}
\description{
This is needed to use Savio or any multicore system effectively.

Another benefit is that the SuperLearner objects for the Q and g estimation
are saved. This allows one to examine the risk estimates for example.
}
\seealso{
setup_parallel_tmle
}
