\name{cfPredict}
\alias{cfPredict}
\title{
Predict the class of new data using an existing ensemble
}
\description{
The \code{cfPredict} function uses a classification ensemble object created by \code{\link{cfBuild}} to predict the class(es) of one or more samples described by a given data matrix. The function returns the predicted classes for each sample, together with a confidence score (between 0 and 100) which equates to the percentage of SVMs within the classifier that voted for the reported class. 
}
\usage{
cfPredict(ensObj, newInputData)
}
\arguments{
  \item{ensObj}{The classification ensemble (in the form of an R list) as generated by \code{\link{cfBuild}}}
  \item{newInputData}{A new independent dataset with unknown classes. The new dataset must have exactly the same number of columns as the \code{inputData}, passed as an argument in \code{\link{cfBuild}}.}
}
\value{
The \code{cfPredict} function returs a matrix of the predicted classes as generated by a majority vote between the classifiers in the ensemble along with their confidence scores (the \% percentage of the predicted class in the majority vote) for each sample. 
}
\seealso{
  \code{\link{cfBuild}}
}
\examples{
\dontrun{
data(iris)

irisClass <- iris[,5]
irisData  <- iris[,-5]

# Construct a classification ensemble with 100 classifiers and 100 bootstrap 
# iterations during optimisation

ens <- cfBuild(irisData, irisClass, bootNum = 100, ensNum = 100, parallel = TRUE, 
               cpus = 4, type = "SOCK")

# Randomly generate test data to find out their classes using the generated ensemble
# 400 points are selected at random, which results in 100 samples (rows).
# Predict the classes of the data using the classifiers in the constructed ensemble

testMatr <- matrix(runif(400)*100, ncol=4)           
predRes  <- cfPredict(ens, testMatr)
}
}
\keyword{classif}
\keyword{multivariate}
\keyword{models}
\keyword{nonlinear}
