/*
 * Decompiled with CFR 0.152.
 */
package edu.richmond.nlp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;

public class ConsoleOutputCapturer {
    private ByteArrayOutputStream baos;
    private PrintStream previous;
    private boolean capturing;

    public void start() {
        if (this.capturing) {
            return;
        }
        this.capturing = true;
        this.previous = System.out;
        this.baos = new ByteArrayOutputStream();
        OutputStreamCombiner outputStreamCombiner = new OutputStreamCombiner(Arrays.asList(this.previous, this.baos));
        PrintStream custom = new PrintStream(outputStreamCombiner);
        System.setOut(custom);
    }

    public String stop() {
        if (!this.capturing) {
            return "";
        }
        System.setOut(this.previous);
        String capturedValue = this.baos.toString();
        this.baos = null;
        this.previous = null;
        this.capturing = false;
        return capturedValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutputStreamCombiner
    extends OutputStream {
        private List<OutputStream> outputStreams;

        public OutputStreamCombiner(List<OutputStream> outputStreams) {
            this.outputStreams = outputStreams;
        }

        @Override
        public void write(int b) throws IOException {
            for (OutputStream os : this.outputStreams) {
                os.write(b);
            }
        }

        @Override
        public void flush() throws IOException {
            for (OutputStream os : this.outputStreams) {
                os.flush();
            }
        }

        @Override
        public void close() throws IOException {
            for (OutputStream os : this.outputStreams) {
                os.close();
            }
        }
    }
}

