% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_quality.R
\name{check_quality}
\alias{check_quality}
\title{Checks data quality of a variable}
\usage{
check_quality(
  x,
  id = 1:length(x),
  plot = TRUE,
  numeric = NULL,
  k = 5,
  n = ifelse(is.numeric(x) | ttrue(numeric) | class(x) \%in\% "Date", 5, 2),
  output = FALSE,
  ...
)
}
\arguments{
\item{x}{A variable from a data.frame}

\item{id}{ID column to reference the found extreme values}

\item{plot}{If the variable is numeric, should a boxplot be drawn?}

\item{numeric}{If set to TRUE, forces the variable to be considered numeric}

\item{k}{Number of different numeric values in a variable to be considered as numeric}

\item{n}{Number of extreme values to extract}

\item{output}{Format of the output. If TRUE, optimize for exporting as csv}

\item{...}{further arguments passed to boxplot()}
}
\value{
A list of a data.frame with information about data quality of the variable
}
\description{
Returns different data quality details of a numeric or categorical variable
}
\examples{
check_quality(airquality$Ozone)  #For one variable
lapply(airquality, check_quality)  #For a data.frame
lapply(airquality, check_quality, output=TRUE)  #For a data.frame, one row per variable
}
