% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_imgw_annual.R
\name{hydro_imgw_annual}
\alias{hydro_imgw_annual}
\title{Semi-annual and annual hydrological data}
\usage{
hydro_imgw_annual(
  year,
  coords = FALSE,
  value = "H",
  station = NULL,
  col_names = "short",
  allow_failure = TRUE,
  ...
)
}
\arguments{
\item{year}{vector of years (e.g., 1966:2000)}

\item{coords}{add coordinates of the stations (logical value TRUE or FALSE)}

\item{value}{type of data (can be: state - "H" (default), flow - "Q", or temperature - "T")}

\item{station}{name or ID of hydrological station(s).
It accepts names (characters in CAPITAL LETTERS) or stations' IDs (numeric)}

\item{col_names}{three types of column names possible:
"short" - default, values with shorten names,
"full" - full English description,
"polish" - original names in the dataset}

\item{allow_failure}{logical - whether to proceed or stop on failure. By default set to TRUE (i.e. don't stop on error). For debugging purposes change to FALSE}

\item{...}{other parameters that may be passed to the 'shortening' function that shortens column names}
}
\value{
data.frame with historical hydrological data for the semi-annual and annual period
}
\description{
Downloading hydrological data for the semi-annual and annual period
available in the danepubliczne.imgw.pl collection
}
\examples{
\donttest{
hydro_yearly = hydro_imgw_annual(year = 2000, value = "H", station = "ANNOPOL")
}
}
