\name{climdex.get.available.indices}
\alias{climdex.get.available.indices}
\title{Get available indices by name}
\usage{
climdex.get.available.indices(ci, function.names = TRUE)
}
\arguments{
  \item{ci}{Object of type climdexInput.}

  \item{function.names}{Whether to return function names.}
}
\value{
A vector containing an annual timeseries of precipitation
in wet days.
}
\description{
This function returns a vector of (function) names of
available indices.
}
\details{
This function takes a climdexInput object as input and
returns the names of all the indices which may be computed
or, if \code{get.function.names} is TRUE (the default), the
names of the functions corresponding to the indices.
}
\examples{
library(PCICt)

## Create a climdexInput object from some data already loaded in and
## ready to go.

## Parse the dates into PCICt.
tmax.dates <- as.PCICt(do.call(paste, ec.1018935.tmax[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")
tmin.dates <- as.PCICt(do.call(paste, ec.1018935.tmin[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")
prec.dates <- as.PCICt(do.call(paste, ec.1018935.prec[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")

## Load the data in.
ci <- climdexInput.raw(ec.1018935.tmax$MAX_TEMP,
ec.1018935.tmin$MIN_TEMP, ec.1018935.prec$ONE_DAY_PRECIPITATION,
tmax.dates, tmin.dates, prec.dates, base.range=c(1971, 2000))

## Get list of functions which might be run.
func.names <- climdex.get.available.indices(ci)
}

