% Generated by roxygen2 (4.0.2): do not edit by hand
\name{climdex.su}
\alias{climdex.su}
\title{Summer Days}
\usage{
climdex.su(ci)
}
\arguments{
\item{ci}{Object of type climdexInput.}
}
\value{
A vector containing the number of summer days for each year.
}
\description{
This function computes the climdex index SU.
}
\details{
This function takes a climdexInput object as input and computes the SU (summer
days) climdex index: that is, the annual count of days where daily maximum
temperature exceeds 25 degrees Celsius.
}
\examples{
library(PCICt)

## Create a climdexInput object from some data already loaded in and
## ready to go.

## Parse the dates into PCICt.
tmax.dates <- as.PCICt(do.call(paste, ec.1018935.tmax[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")
tmin.dates <- as.PCICt(do.call(paste, ec.1018935.tmin[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")
prec.dates <- as.PCICt(do.call(paste, ec.1018935.prec[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")

## Load the data in.
ci <- climdexInput.raw(ec.1018935.tmax$MAX_TEMP,
ec.1018935.tmin$MIN_TEMP, ec.1018935.prec$ONE_DAY_PRECIPITATION,
tmax.dates, tmin.dates, prec.dates, base.range=c(1971, 2000))

## Create an annual timeseries of the number of summer days.
su <- climdex.su(ci)
}
\references{
\url{http://etccdi.pacificclimate.org/list_27_indices.shtml}
}
\seealso{
\code{\link{climdexInput.raw}}, \code{\link{climdexInput.csv}}.
}
\keyword{climate}
\keyword{ts}

