% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/climatewin.R
\name{climatewin}
\alias{climatewin}
\title{Test for a climate window}
\usage{
climatewin(Xvar, CDate, BDate, baseline, furthest, closest, FIXED, cutoff.day,
  cutoff.month, STAT = "mean", FUNC = "L", CMISSING = FALSE,
  CINTERVAL = "D", nrandom = 0)
}
\arguments{
\item{Xvar}{The climate variable of interest. Please specify the parent
  environment and variable name (e.g. Climate$Temp).}

\item{CDate}{The climate date variable (dd/mm/yyyy). Please specify the
  parent environment and variable name (e.g. Climate$Date).}

\item{BDate}{The biological date variable (dd/mm/yyyy). Please specify the
  parent environment and variable name (e.g. Biol$Date).}

\item{baseline}{The baseline model structure used for testing correlation.
  Currently known to support lm, glm, lmer and glmer objects.}

\item{furthest}{The furthest number of time intervals (set by CINTERVAL)
  back from the cutoff date or biological record that you want to include in
  your climate window search.}

\item{closest}{The closest number of time intervals (set by CINTERVAL) back
  from the cutoff date or biological record that you want to include in your
  climate window search.}

\item{FIXED}{TRUE or FALSE, whether you wish the climate window to be
  variable (i.e. the number of days before each biological record is
  measured) or fixed (i.e. number of days before a set point in time).}

\item{cutoff.day,cutoff.month}{If FIXED is TRUE, the day and month of the
  year from which the fixed window analysis will start.}

\item{STAT}{The aggregate statistic used to analyse the climate data. Can
  currently use basic R statistics (e.g. mean, min), as well as slope.
  Additional aggregate statistics can be created using the format
  function(x) (...). See FUN in \code{\link{apply}} for more detail.}

\item{FUNC}{The function used to fit the climate variable. Can be linear
  ("L"), quadratic ("Q"), cubic ("C"), inverse ("I") or log ("LOG").}

\item{CMISSING}{TRUE or FALSE, determines what should be done if there are
  missing climate data. If FALSE, the function will not run if missing
  climate data is encountered. If TRUE, any records affected by missing
  climate data will be removed from climate window analysis.}

\item{CINTERVAL}{The resolution at which climate window analysis will be
  conducted. May be days ("D"), weeks ("W"), or months ("M"). Note the units
  of parameters 'furthest' and 'closest' will differ depending on the choice
  of CINTERVAL.}

\item{nrandom}{Used in conjunction with \code{\link{randwin}}. Not to be
  changed manually.}
}
\value{
Will return a list containing three objects:

   \itemize{ \item BestModel, a model object. The strongest climate window
   model based on AICc. \item BestModelData, a dataframe with the data used
   to fit the strongest climate window model. \item WindowOutput, a dataframe
   with information on all fitted climate windows. Ordered using AICc model
   strength, with lowest AICc value first. See \code{\link{MassOutput}} as an
   example. }
}
\description{
Finds the time period when a biological variable is most strongly affected
 by climate. Note that climate data and biological data should be loaded as
 two seperate objects. Both objects should contain a date column to designate
 when the data were recorded (dd/mm/yyyy) and a response variable column.
}
\examples{
\dontrun{
 ##EXAMPLE 1##

 # Test for a variable climate window using datasets "Offspring"
 # and "OffspringClimate".

 # Load data.

 data(Offspring)
 data(OffspringClimate)

 OffspringWin <- climatewin(Xvar = OffspringClimate$Temperature,
                            CDate = OffspringClimate$Date,
                            BDate = Offspring$Date,
                            baseline = glm(Offspring$Offspring ~ 1, family = poisson),
                            furthest = 150, closest = 0,
                            FIXED = FALSE, STAT = "mean",
                            FUNC = "L", CMISSING = FALSE, CINTERVAL = "D")

 # View output.

 head(OffspringWin[[3]])
 OffspringWin[[1]]

 ##EXAMPLE 2##

 # Test for a fixed climate window using datasets 'Mass' and 'MassClimate'.

 # Load data.

 data(Mass)
 data(MassClimate)

 # Test a fixed window, starting 20 May
 # Test for climate windows between 100 and 0 days ago (furthest = 100, closest = 0)
 # Fit a linear term for the mean climate (FUNC = "L")
 # Test at the resolution of days (CINTERVAL = "D")

 MassWin <- climatewin(Xvar = MassClimate$Temp, CDate = MassClimate$Date, BDate = Mass$Date,
                       baseline = lm(Mass$Mass ~ 1),
                       furthest = 100, closest = 0,
                       STAT = "mean", FUNC = "L",
                       FIXED = TRUE, cutoff.day = 20, cutoff.month = 5,
                       nrandom = 0, CMISSING = FALSE, CINTERVAL = "D")

 # View output

 head(MassWin[[3]])
 MassWin[[1]]
 }
}
\author{
Liam D. Bailey and Martijn van de Pol
}

