% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/absolute2relative.R
\name{absolute2relative_bsa}
\alias{absolute2relative_bsa}
\title{Convert quantity expressed in absolute units relative to normalized BSA}
\usage{
absolute2relative_bsa(quantity, bsa = NULL, ...)
}
\arguments{
\item{quantity}{quantity expressed in absolute units}

\item{bsa}{ideal body weight in kg}

\item{...}{arguments passed on to `calc_bsa`, if bsa is NULL}
}
\value{
quantity expressed relative to /1.73m2
}
\description{
Often used for eGFR estimates
}
\examples{
absolute2relative_bsa(quantity = 60, bsa = 1.6)
absolute2relative_bsa(quantity = 60, weight = 14, height = 90, method = "dubois")
}
