% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_1cmt_bolus_ss.R
\name{pk_1cmt_bolus_ss}
\alias{pk_1cmt_bolus_ss}
\title{Concentration predictions for 1-compartmental PK model with bolus dosing at steady state}
\usage{
pk_1cmt_bolus_ss(t = c(0:24), dose = 100, tau = 12, CL = 3, V = 30, ruv = NULL)
}
\arguments{
\item{t}{vector of time}

\item{dose}{dose}

\item{tau}{dosing interval}

\item{CL}{clearance}

\item{V}{volume of distribution}

\item{ruv}{residual variability, specified as list with optional arguments for proportional, additive, or exponential components, e.g. `list(prop=0.1, add=1, exp=0)`}
}
\description{
Concentration predictions for 1-compartmental PK model with bolus dosing at steady state
}
\examples{
pk_1cmt_bolus_ss(dose = 500, tau = 12, CL = 5, V = 50)
pk_1cmt_bolus_ss(
  dose = 500, tau = 12, CL = 5, V = 50,
  ruv = list(prop = 0.1, add = 0.1))
}
