% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_2cmt_inf_ss.R
\name{pk_2cmt_inf_ss}
\alias{pk_2cmt_inf_ss}
\title{Concentration predictions for 1-compartmental PK model with infusion dosing at steady state}
\usage{
pk_2cmt_inf_ss(t = c(0:24), dose = 100, t_inf = 1, tau = 12, CL = 3,
  V = 30, Q = 2, V2 = 20, ruv = NULL)
}
\arguments{
\item{t}{vector of time}

\item{dose}{dose}

\item{t_inf}{infusion time}

\item{tau}{dosing interval}

\item{CL}{clearance}

\item{V}{volume of distribution}

\item{Q}{inter-compartimental clearance}

\item{V2}{volume of peripheral compartment}

\item{ruv}{residual variability, specified as list with optional arguments for proportional, additive, or exponential components, e.g. `list(prop=0.1, add=1, exp=0)`}
}
\description{
Concentration predictions for 1-compartmental PK model with infusion dosing at steady state
}
\examples{
pk_2cmt_inf_ss(
  dose = 1000, tau = 12, t_inf = 2,
  CL = 5, V = 50, Q = 20, V2 = 200)
}
