% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareTables.R
\name{mergeDiffWithData}
\alias{mergeDiffWithData}
\title{Merge the 'diff.data' object from \code{\link{compareDiff}}
with the original \code{newData} or \code{oldData}.}
\usage{
mergeDiffWithData(diffData, newData, oldData)
}
\arguments{
\item{diffData}{Object of class 'diff.data' containing
differences between datasets, as returned by the \code{\link{compareDiff}} function.}

\item{newData}{data.frame object representing the new data}

\item{oldData}{data.frame object representing the old data}
}
\value{
The \code{newData} or \code{oldData} (as a data frame object)
with the extra column 'Comparison type' specifying the type
of change, either:
\itemize{
\item{'Change': }{record present in both dataset based 
on the reference variables, but with changes in the
changeable variables}
\item{'Addition': }{records present in new but not in old data}
\item{'Removal': }{records present in old but not in new data}
\item{'Identical': }{records identical in the old and new datasets
(on both the reference and changeable variables)}
}
}
\description{
The \code{newData}/\code{oldData} are merged 
with \code{diffData} based on the columns of \code{diffData}
excepted 'Comparison type' and 'Version'.
}
