% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_summary_table.R
\name{get_summary_table}
\alias{get_summary_table}
\title{Get A Summary Table From A clinisig Object}
\usage{
get_summary_table(x, which = c("individual", "group"))
}
\arguments{
\item{x}{A clinisig object.}

\item{which}{Which level of summary table to return. This is only necessary
for method \code{"HA"} since two summary tables are reported. Available are
\itemize{
\item \code{individual}, the default
\item \code{group}, group level results according to Hageman & Arrindell (1999)
}}
}
\value{
A tibble with clinical significance categories
}
\description{
Retrieve the summary table in a tidy tibble format. This is especially useful
to plot the results or conduct sensitivity analyses.
}
\examples{
results <- jacobson_1989 \%>\%
  clinical_significance(
    id = subject,
    time = time,
    outcome = gds,
    pre = "pre",
    reliability = 0.80,
    m_functional = 30,
    sd_functional = 10,
    type = "c"
  )

results_ha <- jacobson_1989 \%>\%
  clinical_significance(
    id = subject,
    time = time,
    outcome = gds,
    pre = "pre",
    reliability = 0.80,
    m_functional = 30,
    sd_functional = 10,
    type = "c",
    method = "HA"
  )

get_summary_table(results)
get_summary_table(results_ha)
get_summary_table(results_ha, which = "group")
}
\references{
\itemize{
\item Hageman, W. J., & Arrindell, W. A. (1999). Establishing clinically significant change: increment of precision and the distinction between individual and group level analysis. Behaviour Research and Therapy, 37(12), 1169–1193. https://doi.org/10.1016/S0005-7967(99)00032-7
}
}
