% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_data}
\alias{get_data}
\title{Get Data From A clinisig Object}
\usage{
get_data(x, dataset = "data")
}
\arguments{
\item{x}{A clinisig object.}

\item{dataset}{The dataset you wish to retrieve. Available options are
\itemize{
\item \code{"original"} (the raw original dataset)
\item \code{"wide"} (the original dataset in wide format)
\item \code{"data"} (the dataset which is used in the calculations).
The default is \code{"data"}
}}
}
\value{
A tibble
}
\description{
Get Data From A clinisig Object
}
\examples{
results <- jacobson_1989 \%>\%
  clinical_significance(
    id = subject,
    time = time,
    outcome = gds,
    pre = "pre",
    reliability = 0.80,
    m_functional = 30,
    sd_functional = 10,
    type = "c"
  )

get_data(results)
get_data(results, "wide")
get_data(results, "original")
}
