% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_loci.R
\name{combine_loci}
\alias{combine_loci}
\title{Combine the genotype frequencies and transition matrices of two genetic loci}
\usage{
combine_loci(geno_freq1, geno_freq2, trans1, trans2, annotate = FALSE)
}
\arguments{
\item{geno_freq1}{A vector of strictly positive numbers that sum to \code{1},
with \code{geno_freq1[i]} interpreted as the population genotype frequency of the
\code{i}th possible genotype at a genetic locus (locus 1).
When \code{annotate} is \code{TRUE}, the names of the genotypes at locus 1 will be
taken to be \code{names(geno_freq1)} or, if \code{names(geno_freq1)} is \code{NULL}, to be
\code{1:length(geno_freq1)}.}

\item{geno_freq2}{Similar to \code{geno_freq1} (above) but interpreted as the
population genotype frequencies for a different genetic locus (locus 2).}

\item{trans1}{An \code{ngeno1^2} by \code{ngeno1} matrix of non-negative numbers
whose rows sum to \code{1}, where \code{ngeno1 = length(geno_freq1)}.
This matrix is usually generated by \code{\link{trans_monogenic}} or a similar
helper function, and its elements are interpreted as genetic
transmission probabilities for locus 1 (see \code{\link{trans_monogenic}}
for more details).  If \code{trans1} has \code{ngeno1 + 2} instead of \code{ngeno1} columns,
as could occur if it was generated by
\code{\link{trans_monogenic}} with \code{annotate = TRUE}, then the first two
columns will be deleted and \code{trans1} will be converted to a matrix.}

\item{trans2}{Similar to \code{trans1} (above) but interpreted as the
genetic transmission probabilities for locus 2.}

\item{annotate}{A logical flag. When \code{FALSE} (the default), the function
returns objects that can be used as the \code{geno_freq} and \code{trans} arguments of
\code{\link{pedigree_loglikelihood}}. When \code{TRUE}, the function annotates
these objects (and converts \code{trans} to a data frame) to make the output more
easily understood by humans.}
}
\value{
A list with the following components:
\item{geno_freq}{A vector of strictly positive numbers (the joint genotype
frequencies) that sum to \code{1}, with genotype names added when \code{annotate} is \code{TRUE}}
\item{trans}{Either a matrix of genetic transmission probabilities suitable to be
used as the \code{trans} argument of \code{\link{pedigree_loglikelihood}}
(if \code{annotate} is \code{FALSE}), or a data frame that is an annotated version of
this matrix (if \code{annotate} is \code{TRUE}).}
\item{genotype_decoder}{A data frame giving the locus 1 and locus 2 genotypes
that correspond to each joint genotype.  In some cases, this could aid the user's
calculation of the \code{penet} argument of \code{\link{pedigree_loglikelihood}}.}
}
\description{
A function to calculate the genotype frequencies and the transition matrices
for the joint genotypes of two unlinked genetic loci in linkage
equilibrium, given the corresponding objects for the separate loci.
The results from this function can be used as inputs to
\code{\link{pedigree_loglikelihood}} or
\code{\link{genotype_probabilities}}
to model the combined effect of the two loci on phenotypes.
}
\details{
This function combines the genotype frequencies and transition
probabilities of two unlinked genetic loci that are in linkage equilibrium
in a given population.  Because
the loci are unlinked, any person's genotypes at the two loci are
conditionally independent given his or her parental genotypes,
and because the loci are in linkage equilibrium, the genotypes at the two
loci for a random person from the population are independent.
This function uses these assumptions to calculate the population frequencies
and transition probabilities for the joint genotypes of the two loci, where a
joint genotype is just a pair consisting of a genotype at locus 1
and a genotype at locus 2.  If the \code{annotate} option is set to \code{FALSE} then
these frequencies and probabilities can be used in
\code{\link{pedigree_loglikelihood}} to model the combined effect of the two
loci on the phenotypes.  By a repeated application of this function, more
than two genetic loci can be included in the genetic model.
}
\examples{
pa1 <- c(0.9, 0.1); names(pa1) <- c("-","+")
pa2 <- c(0.5, 0.5); names(pa2) <- c("A","a")
(geno_freq1 <- geno_freq_monogenic(pa1, TRUE))
(geno_freq2 <- geno_freq_monogenic(pa2, TRUE))
(trans1 <- trans_monogenic(2, TRUE))
(trans2 <- trans_monogenic(2))
(cl <- combine_loci(geno_freq1, geno_freq2, trans1, trans2, TRUE))
sum(cl$geno_freq)
apply(cl$trans[,-(1:2)], 1, sum)

}
