% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cle.rord.R
\name{cle.rord}
\alias{cle.rord}
\title{Composite Likelihood Estimation for Replciations of Spatial Ordinal Data}
\usage{
cle.rord(response, covar, location, radius = 4, n.sim = 100,
  output = TRUE)
}
\arguments{
\item{response}{a matrix of observation (row: spatial site and column: subject).}

\item{covar}{regression (design) matrix, including intercepts.}

\item{location}{a matrix contains spatial location of sites within each subject}

\item{radius}{radius for selecting pairs for the composite likelihood estimation.}

\item{n.sim}{number of simulation used for parametric bootstrapping (and hence used for asymptotic variance and standard error).}

\item{output}{logical flag indicates whether printing out result (default: \code{TRUE}).}
}
\value{
\code{cle.rord} returns a list contains:

\code{vec.par}: a vector of estimator for \eqn{\theta=(\alpha,\beta,\sigma^2,\phi)};

\code{vec.se}: a vector of standard error for the estimator;

\code{mat.asyvar}: estimated asymptotic covariance matrix \eqn{H^{-1}(\theta)J(\theta)H^{-1}(\theta)} for the estimator; and

\code{mat.Hessian}: Hessian matrix at the parameter estimate.

\code{mat.J}: Sensitivity matrix estimated by parametric boostrapping.

\code{CLIC}: Composite likelihood information criterion (see help manual of \code{clic()} for detail)
}
\description{
\code{cle.rord} Estimate parameters (including regression coefficient and cutoff) for replications of spatial ordinal data using pairwise likelihood approach. Initial estimate is calculated by assuming ther is no spatial dependence (using \code{MASS::polr()})
}
\details{
Given vector of ordinal responses, the design matrix, spatial location for sites, weight radius (for pair selection), and the prespecified number of simulation used for estimating the Godambe information matrix. The function first estimates parameters of interest by maximizing the composite log-likelihood using \code{optim(...,method = "L-BFGS-B")}, then computes the simulated based standard error and asymptotic covariance matrix by parametric boostrapping.
}
\examples{
set.seed(1203)
n.subject <- 50
n.lat <- n.lon <- 10
n.site <- n.lat*n.lon

beta <- c(1,2,-1) # First 1 here is the intercept
midalpha <- c(1.15, 2.18) ; sigma2 <- 0.7 ; phi <- 0.8

true <- c(midalpha,beta,sigma2,phi)

Xi <- rnorm(n.subject,0,1) ; Xj <- rbinom(n.site,1,0.6)

 VV <- matrix(NA, nrow = n.subject*n.site, ncol = 3)

 for(i in 1:n.subject){ for(j in 1:n.site){
     VV[(i-1)*n.site+j,] <- c(1,Xi[i],Xj[j])
       }
 }

location <- cbind(rep(seq(1,n.lat,length=n.lat),n.lat),rep(1:n.lon, each=n.lon))
sim.data <- sim.rord(n.subject, n.site, n.rep = 2, midalpha, beta, sigma2, phi, covar=VV, location)

\dontrun{
options(digits=3)
result <- cle.rord(response=sim.data[[1]], covar=VV,
          location ,radius = 4, n.sim = 100, output = FALSE)
result$vec.par
# alpha2  alpha3   beta0   beta1   beta2 sigma^2     phi
# 1.195   2.223   0.880   1.859  -0.956   0.754   0.828

result$vec.se
# alpha2  alpha3   beta0   beta1   beta2 sigma^2     phi
# 0.0469  0.0677  0.0700  0.0884  0.0446  0.1024  0.0557

}


}
