% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivreg.R
\name{vcovCR.ivreg}
\alias{vcovCR.ivreg}
\title{Cluster-robust variance-covariance matrix for an ivreg object.}
\usage{
\method{vcovCR}{ivreg}(obj, cluster, type, target = NULL,
  inverse_var = FALSE, form = "sandwich", ...)
}
\arguments{
\item{obj}{Fitted model for which to calculate the variance-covariance matrix}

\item{cluster}{Expression or vector indicating which observations belong to
the same cluster. Required for \code{ivreg} objects.}

\item{type}{Character string specifying which small-sample adjustment should 
be used, with available options \code{"CR0"}, \code{"CR1"}, \code{"CR1p"},
\code{"CR1S"}, \code{"CR2"}, or \code{"CR3"}. See "Details" section of 
\code{\link{vcovCR}} for further information.}

\item{target}{Optional matrix or vector describing the working
variance-covariance model used to calculate the \code{CR2} and \code{CR4}
adjustment matrices. If a vector, the target matrix is assumed to be
diagonal. If not specified, the target is taken to be an identity matrix.}

\item{inverse_var}{Not used for \code{ivreg} objects.}

\item{form}{Controls the form of the returned matrix. The default 
\code{"sandwich"} will return the sandwich variance-covariance matrix. 
Alternately, setting \code{form = "meat"} will return only the meat of the 
sandwich and setting \code{form = B}, where \code{B} is a matrix of 
appropriate dimension, will return the sandwich variance-covariance matrix 
calculated using \code{B} as the bread.}

\item{...}{Additional arguments available for some classes of objects.}
}
\value{
An object of class \code{c("vcovCR","clubSandwich")}, which consists
  of a matrix of the estimated variance of and covariances between the
  regression coefficient estimates.
}
\description{
\code{vcovCR} returns a sandwich estimate of the variance-covariance matrix 
of a set of regression coefficient estimates from an \code{\link[AER]{ivreg}} object.
}
\examples{
library(AER)
data("CigarettesSW")
Cigs <- within(CigarettesSW, {
  rprice <- price/cpi
  rincome <- income/population/cpi
  tdiff <- (taxs - tax)/cpi
})

iv_fit <- ivreg(log(packs) ~ log(rprice) + log(rincome) | 
                log(rincome) + tdiff + I(tax/cpi), data = Cigs)
vcovCR(iv_fit, cluster = Cigs$state, type = "CR2")
coef_test(iv_fit, vcov = "CR2", cluster = Cigs$state)
      
}
\seealso{
\code{\link{vcovCR}}
}
