% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{fix_num_points}
\alias{fix_num_points}
\title{Certify that array values add up to a specific total}
\usage{
fix_num_points(clu_num_points, num_points)
}
\arguments{
\item{clu_num_points}{Number of points in each cluster (vector of size
\mjseqn{c}), where \mjseqn{c} is the number of clusters.}

\item{num_points}{The expected total number of points.}
}
\value{
Number of points in each cluster, after being fixed by this function.
}
\description{
\loadmathjax
Certifies that the values in the \code{clu_num_points} array, i.e. the number of
points in each cluster, add up to \code{num_points}. If this is not the case, the
\code{clu_num_points} array is modified in-place, incrementing the value
corresponding to the smallest cluster while
\code{sum(clu_num_points) < num_points}, or decrementing the value corresponding
to the largest cluster while \code{sum(clu_num_points) > num_points}.
}
\details{
This function is used internally by \link{clusizes} and might be useful for
custom cluster sizing implementations given as the \code{clusizes_fn} parameter of
the main \link{clugen} function.
}
\examples{
clusters <- c(1, 6, 3)                   # 10 total points
clusters <- fix_num_points(clusters, 12) # But we want 12 total points
clusters                                 # Check that we now have 12 points
}
