% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hare_niemeyer.R
\name{hare_niemeyer}
\alias{hare_niemeyer}
\title{Seat Distribution by Hare/Niemeyer}
\usage{
hare_niemeyer(votes, parties, n_seats = 183)
}
\arguments{
\item{votes}{Number of votes per party.}

\item{parties}{Names of parties (must be same length as votes).}

\item{n_seats}{Number of seats in parliament. Defaults to 183 (seats in
Austrian parliament).}
}
\value{
A \code{data.frame} containing parties above the hurdle and the respective
seats/percentages after redistribution via Hare/Niemeyer
}
\description{
Calculates number of seats for the respective parties that have received more
than \code{hurdle} percent of votes (according to the method of Hare/Niemeyer)
}
\examples{
library(coalitions)
library(dplyr)
# get the latest survey for a sample of German federal election polls
surveys <- get_latest(surveys_sample) \%>\% tidyr::unnest("survey")
# calculate the seat distribution based on Hare/Niemeyer for a parliament with 300 seats
hare_niemeyer(surveys$votes, surveys$party, n_seats = 300)
}
\seealso{
\code{\link{sls}}
}
