% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{copybig}
\alias{copybig}
\title{Decide if large objects should be copied}
\usage{
copybig(x, .copy = NA)
}
\arguments{
\item{x}{object (potentially of large size)}

\item{.copy}{Should the object be copied internally by \code{\link[data.table:copy]{data.table::copy()}}?
\code{NA} (by default) means that objects smaller than 1 GB are copied.
If the size is larger, the argument must be set explicitly. Set \code{TRUE}
to make copies regardless of object size. This is recommended if enough RAM
is available. If set to \code{FALSE}, calculations might be carried out
but the object will be changed by reference.
IMPORTANT! This might lead to undesired consequences and should only be used
if absolutely necessary!}
}
\value{
Either \code{x} unchanged, or a fresh copy of \code{x}.
}
\description{
Decide if large objects should be copied
}
\keyword{internal}
