% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_contrast.R
\name{calc_contrast}
\alias{calc_contrast}
\title{Calculate contrast analysis for factorial designs}
\usage{
calc_contrast(
  dv,
  between = NULL,
  lambda_between = NULL,
  within = NULL,
  lambda_within = NULL,
  ID = NULL,
  id = NULL,
  data = NULL
)
}
\arguments{
\item{dv}{dependent variable. Values must be numeric.}

\item{between}{independent variable that divides the data into
independent groups. Vector must be a factor.}

\item{lambda_between}{contrast weights must be a named numeric.
Names must match the levels of \code{between}. If
\code{lambda_between}
does not sum up to zero, this will be done automatically.}

\item{within}{independent variable which divides the data into
dependent groups. This must be a factor.}

\item{lambda_within}{contrast must be a named numeric.
Names must match the levels of \code{between}. If
\code{lambda_between}
does not sum up to zero, this will be done automatically.}

\item{ID}{deprecated, use id instead}

\item{id}{identifier for cases or subjects is needed
for within- and mixed contrast analysis.}

\item{data}{optional argument for the \code{data.frame}
containing \code{dv} and groups.}
}
\value{
an object of type cofad_bw or cofad_wi or cofad_mx, including
  p-value, F-value, contrast weights, different effect sizes. Call summary
  on this object to get a nice overview of all relevant statistics. Call
  print to get a short text that can be used for a report.
}
\description{
Calculate contrast analysis for factorial designs
}
\details{
For multi-factorial designs, the lambda weights of
the factors must be connected.

Note that cofad returns one-sided p-values for t-tests.
}
\examples{
# Example for between-subjects design Table 3.1 from
# Rosenthal, Rosnow and Rubin (2001)

data(rosenthal_tbl31)
contr_bw <- calc_contrast(
   dv = dv,
   between = between,
   lambda_between = c("A" = -3, "B" = -1, "C" = 1, "D" = 3),
   data = rosenthal_tbl31)
contr_bw
summary(contr_bw)

# Example for within-subjects design Calculation 16.6 from
# Sedlmeier and Renkewitz (2018, p. 537)

data(sedlmeier_p537)
contr_wi <- calc_contrast(
   dv = reading_test,
   within = music,
   id = participant,
   lambda_within = c(
     "without music" = 1.25,
     "white noise" = 0.25,
     "classic" = -0.75,
     "jazz" = -0.75
   ),
   data = sedlmeier_p537
 )
contr_wi
summary(contr_wi, ci = .90)

# Example for mixed-design Table 5.3 from
# Rosenthal, Rosnow and Rubin (2001)

data(rosenthal_tbl53)

contr_mx <- calc_contrast(dv = dv, between = between,
              lambda_between = c("age8" = -1, "age10" = 0, "age12" = 1),
              within = within,
              lambda_within = c("1" = -3, "2" = -1,"3" = 1, "4" = 3),
              id = id, data = rosenthal_tbl53
              )
contr_mx
summary(contr_mx)

}
\references{
Rosenthal, R., Rosnow, R.L., & Rubin, D.B. (2000). Contrasts and
  effect sizes in behavioral research: A correlational approach. New York:
  Cambridge University Press.
}
