% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cointReg-IM-OLS.R
\name{cointRegIM}
\alias{cointRegIM}
\title{Integrated Modified OLS}
\usage{
cointRegIM(x, y, deter, selector = 1, t.test = TRUE, kernel = c("ba",
  "pa", "qs", "tr"), bandwidth = c("and", "nw"), check = TRUE, ...)
}
\arguments{
\item{x}{[\code{numeric} | \code{matrix} | \code{data.frame}]\cr
RHS variables on which to apply the IM-OLS estimation (see Details).}

\item{y}{[\code{numeric} | \code{matrix} | \code{data.frame}]\cr
LHS variable(s) on which to apply the IM-OLS estimation (see Details).
Has to be one-dimensional. If \code{matrix}, it may
have only one row or column, if \code{data.frame} just one column.}

\item{deter}{[\code{numeric} | \code{matrix} | \code{data.frame} |
            \code{NULL}]\cr
Deterministic variable to include in the equation (see Details). If it's
\code{NULL} or missing, no deterministic variable is included in the model.}

\item{selector}{[\code{numeric}]\cr
Choose the regression type: \code{1}, \code{2}, or \code{c(1, 2)}
(see Details). Default is \code{1}.}

\item{t.test}{[\code{logical}]\cr
Wheather to calculate t-values for the coefficients of the first
regression. Default is \code{TRUE}. Attention: Needs more calculation
time, because an additional FM-OLS model has to be fitted to get the
long-run variance.}

\item{kernel}{[\code{character(1)}]\cr
The kernel function to use for calculating the long-run variance.
Default is Bartlett kernel (\code{"ba"}), see Details for alternatives.}

\item{bandwidth}{[\code{character(1)} | \code{integer(1)}]\cr
The bandwidth to use for calculating the long-run variance.
Default is Andrews (1991) (\code{"and"}), an alternative is Newey West
(1994) (\code{"nw"}).}

\item{check}{[\code{logical}]\cr
Wheather to check (and if necessary convert) the arguments.
See \code{\link{checkVars}} for further information.}

\item{...}{Arguments passed to \code{\link{getBandwidthNW}}.}
}
\value{
[\code{cointReg}]. List with components:
\describe{
  \item{\code{delta} [\code{numeric}]}{
    coefficients of the deterministics (cumulative sum \eqn{S_{deter}})}

  \item{\code{beta} [\code{numeric}]}{
    coefficients of the regressors (cumulative sum \eqn{S_{x}})}

  \item{\code{gamma} [\code{numeric}]}{
    coefficients of the regressors (original regressors \eqn{x})}

  \item{\code{theta} [\code{numeric}]}{
    combined coefficients of \code{beta}, \code{delta}}

  \item{\code{sd.theta} [\code{numeric}]}{
    standard errors for the \code{theta} coefficients}

  \item{\code{t.theta} [\code{numeric}]}{
    t-values for the \code{theta} coefficients}

  \item{\code{p.theta} [\code{numeric}]}{
    p-values for the \code{theta} coefficients}

  \item{\code{theta.all} [\code{numeric}]}{
    combined coefficients of \code{beta}, \code{delta}, \code{gamma}}

  \item{\code{residuals} [\code{numeric}]}{
    IM-OLS residuals. Attention: These are the first differences of
    \eqn{S_u} -- the original residuals are stored in \code{u.plus}.}

  \item{\code{u.plus} [\code{numeric}]}{
    IM-OLS residuals, not differenced. See \code{residuals} above.}

  \item{\code{omega.u.v} [\code{numeric}]}{
    conditional long-run variance based on OLS residuals, via
    \code{cointRegFM} (in case of argument \code{t.test} is \code{TRUE})
    or \code{NULL}}

  \item{\code{varmat} [\code{matrix}]}{
    variance-covariance matrix}

  \item{\code{Omega} [\code{matrix}]}{
    \code{NULL} (no long-run variance matrix for this regression type)}

  \item{\code{bandwidth} [\code{list}]}{
    \code{number} and \code{name} of bandwidth if \code{t.test = TRUE}}

  \item{\code{kernel} [\code{character}]}{
    abbr. name of kernel type if \code{t.test = TRUE}}

  \item{\code{delta2} [\code{numeric}]}{
    coefficients of the deterministics (cumulative sum \eqn{S_{deter}})
    for regression type 2}

  \item{\code{beta2} [\code{numeric}]}{
    coefficients of the regressors (cumulative sum \eqn{S_{x}})
    for regression type 2}

  \item{\code{gamma2} [\code{numeric}]}{
    coefficients of the regressors (original regressors \eqn{x})
    for regression type 2}

  \item{\code{lambda2} [\code{numeric}]}{
    coefficients of the Z regressors for regression type 2}

  \item{\code{theta2} [\code{numeric}]}{
    combined coefficients of \code{beta2}, \code{delta2}, \code{gamma2} and
    \code{lambda2} for regression type 2}

  \item{\code{u.plus2} [\code{numeric}]}{
    IM-OLS residuals for regression type 2}
}
}
\description{
Computes the Vogelsang and Wagner (2014) Integrated Modified OLS estimator.
}
\details{
The equation for which the IM-OLS estimator is calculated (type 1):
\deqn{S_y = \delta \cdot S_{D} + \beta \cdot S_{x} + \gamma \cdot x + u}{
S[y] = \delta * S[D] + \beta * S[x] + \gamma * x + u}
where \eqn{S_y}{S[y]}, \eqn{S_x}{S[x]} and \eqn{S_D}{S[D]} are the cumulated
sums of \eqn{y}, \eqn{x} and \eqn{D} (with \eqn{D} as the deterministics
matrix).
Then \eqn{\theta = (\delta', \beta', \gamma')'} is the full parameter vector.

The equation for which the IM-OLS estimator is calculated (type 2):
\deqn{S_y = \delta \cdot S_D + \beta \cdot S_x + \gamma \cdot x +
\lambda \cdot Z + u}{S[y] = \delta * S[D] + \beta * S[x] + \gamma * x +
\lambda * Z + u}
where \eqn{S_y}{S[y]}, \eqn{S_x}{S[x]} and \eqn{S_D}{S[D]} are the cumulated
sums of \eqn{y}, \eqn{x} and \eqn{D} (with \eqn{D} as the deterministics
matrix) and \eqn{Z} as defined in equation (19) in Vogelsang and Wagner
(2015).
Then \eqn{\theta = (\delta', \beta', \gamma', \lambda')'} is the full
parameter vector.
}
\examples{
set.seed(1909)
x1 = cumsum(rnorm(100, mean = 0.05, sd = 0.1))
x2 = cumsum(rnorm(100, sd = 0.1)) + 1
x3 = cumsum(rnorm(100, sd = 0.2)) + 2
x = cbind(x1, x2, x3)
y = x1 + x2 + x3 + rnorm(100, sd = 0.2) + 1
deter = cbind(level = 1, trend = 1:100)
test = cointRegIM(x, y, deter, selector = c(1, 2), t.test = TRUE,
                    kernel = "ba", bandwidth = "and")
print(test)

}
\references{
\itemize{
    \item Vogelsang, T.J. and M. Wagner (2014): "Integrated Modified OLS
          Estimation and Fixed-b Inference for Cointegrating Regressions,"
          \emph{Journal of Econometrics}, 148, 741--760,
          \href{http://dx.doi.org/10.1016/j.jeconom.2013.10.015}{DOI:10.1016/j.jeconom.2013.10.015}.
  }
}
\seealso{
Other cointReg: \code{\link{cointRegD}},
  \code{\link{cointRegFM}}, \code{\link{cointReg}},
  \code{\link{plot.cointReg}}, \code{\link{print.cointReg}}
}

