% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_raw_image_handling.R
\name{getImagePaths}
\alias{getImagePaths}
\title{Fetch paths to all valid images in a given directory}
\usage{
getImagePaths(path)
}
\arguments{
\item{path}{Path to directory in which to search for images. Absolute or
relative filepaths are fine.}
}
\value{
A vector of absolute filepaths to JPG and PNG images in the given
  directory.
}
\description{
Find all valid image paths (PNG and JPG) in a directory (does not search
subdirectories). Will recover any image ending in .PNG, .JPG, or .JPEG,
case-insensitive.
}
\note{
In the event that no compatible images are found in the directory, it
returns a message to that effect instead of an empty vector.
}
\examples{
im.dir <- colordistance::getImagePaths(system.file("extdata",
"Heliconius/Heliconius_A", package="colordistance"))
\dontrun{
im.dir <- colordistance::getImagePaths("some/nonexistent/directory")
}
im.dir <- colordistance::getImagePaths(getwd())

}
