% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorpatch_impl.R
\name{DistColorFun}
\alias{DistColorFun}
\title{Creates a color distance function}
\usage{
DistColorFun(color.space = "LAB")
}
\arguments{
\item{color.space}{Color space to be used (see \link[colorspace:color-class]{colorspace::color})}
}
\value{
A function mapping two color values of a color class \link[colorspace:color-class]{colorspace::color} to a numeric value.
}
\description{
Creates a color distance function
}
\examples{
library(colorspace)
library(colorpatch)
fn <- DistColorFun("LUV")
a <- sRGB(1,0,0)
b <- sRGB(0.8,0.1,0)
my.distance <- fn(a,b)
}
