% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorpatch_ggplot.R
\name{stat_colorpatch}
\alias{stat_colorpatch}
\title{A stat function for the use with ggplot2}
\usage{
stat_colorpatch(mapping = NULL, data = NULL, geom = "tile",
  position = "identity", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, color.fun = ColorPatchColorFun(),
  size.fun = ColorPatchSizeFun(), ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{ggplot2::aes()}}.
If specified and \code{inherit.aes = TRUE} (the default), it is combined with the default mapping at the top level of the plot.
You must supply mapping if there is no plot mapping.}

\item{data}{The data to be displayed in this layer.}

\item{geom}{Defaults to \code{tile}.}

\item{position}{Position adjustment, either as a string, or the
result of a call to a position adjustment function.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a warning.
If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather than
combining with them. This is most useful for helper functions that define
both data and aesthetics and shouldn't inherit behaviour from the default
plot specification, e.g. borders.}

\item{color.fun}{Color function mapping a (ratio,conf) pair to a color (defaults to \code{\link[colorpatch:ColorPatchColorFun]{colorpatch::ColorPatchColorFun()}}).}

\item{size.fun}{Size function mapping a (ratio,conf) pair to a rectangle size (defaults to \code{\link[colorpatch:ColorPatchSizeFun]{colorpatch::ColorPatchSizeFun()}} returning constantly 1).}

\item{...}{Further arguments given to the \link[colorpatch:StatColorPatch]{colorpatch::StatColorPatch} ggproto object.
Here thresh.ratio, thresh.conf are the most important parameters.}
}
\value{
a ggplot statistics layer for showing color patches
}
\description{
A stat function for the use with ggplot2
}
