% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regressions.R
\name{rf}
\alias{rf}
\alias{survforest}
\alias{qrf}
\alias{lasso}
\alias{ridge}
\alias{postlasso}
\alias{cox}
\title{Implemented regression methods}
\usage{
rf(y, x, ...)

survforest(y, x, ...)

qrf(y, x, ...)

lasso(y, x, ...)

ridge(y, x, ...)

postlasso(y, x, ...)

cox(y, x, ...)
}
\arguments{
\item{y}{Vector (or matrix) of response values.}

\item{x}{Design matrix of predictors.}

\item{...}{Additional arguments passed to the underlying regression method.
In case of \code{"rf"}, \code{"survforest"} and \code{"qrf"}, this is
\code{\link[ranger]{ranger}}. In case of \code{"lasso"} and
\code{"ridge"}, this is \code{\link[glmnet]{glmnet}}. In case of
\code{"cox"}, this is \code{\link[survival]{coxph}}.}
}
\description{
Implemented regression methods
}
\details{
The implemented choices are \code{"rf"} for random forests as implemented in
ranger, \code{"lasso"} for cross-validated Lasso regression (using the
one-standard error rule), \code{"ridge"}
for cross-validated ridge regression (using the one-standard error rule),
\code{"cox"} for the Cox proportional
hazards model as implemented in survival, \code{"qrf"} or \code{"survforest"}
for quantile and survival random forests, respectively. The option
\code{"postlasso"} option refers to a cross-validated LASSO (using the
one-standard error rule) and subsequent OLS regression.
New regression methods can be implemented and supplied as well and need the
following structure. The regression method \code{"custom_reg"} needs to take
arguments \code{y, x, ...}, fit the model using \code{y} and \code{x} as
matrices and return an object of a user-specified class, for instance,
'\code{custom}'. For the GCM test, implementing a \code{residuals.custom}
method is sufficient, which should take arguments
\code{object, response = NULL, data = NULL, ...}. For the PCM test, a
\code{predict.custom} method is necessary for out-of-sample prediction
and computation of residuals.
}
